package net.mingsoft.mdiy.parser.bean;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * 
 * @ClassName: TagBean
 * @Description:TODO(tag对象)
 * @author: 铭飞开发团队
 * @date: 2018年10月23日 下午3:00:14
 * 
 * @Copyright: 2018 www.mingsoft.net Inc. All rights reserved.
 */
public class TagBean {
	/**
	 * 标签参数：如:size=4
	 */
	private Map params = new HashMap();
	/**
	 * 标签代码块原始内容
	 */
	private String content;

	/**
	 * 开始标签：完整一行{ms:arclist-0 flag=c flag=f size=5 titlelen=45 typeid=2734}
	 */
	private String beginTag;

	/**
	 * 结束标签：{/ms:arclist-0}
	 */
	private String endTag;

	/**
	 * 子标签
	 */
	private TagBean child;
	
	

	public String getContent() {
		return content;
	}

	public void setContent(String content) {
		this.content = content;
	}

	public Map getParams() {
		return params;
	}

	public void setParams(Map params) {
		this.params = params;
	}

	public String getBeginTag() {
		return beginTag;
	}

	public void setBeginTag(String beginTag) {
		this.beginTag = beginTag;
	}

	public String getEndTag() {
		return endTag;
	}

	public void setEndTag(String endTag) {
		this.endTag = endTag;
	}

	public TagBean getChild() {
		if (this.child == null) {
			
			String p = "\\{ms:.*? ";
			Pattern r = Pattern.compile(p);
			Matcher m = r.matcher(content);
			int i = 0;
			String child = null;
			while (m.find()) {
				if (i == 1) {
					child = m.group();
				}
				i++;
			}
			
			if(child !=null ) {
				this.child = new TagBean();
				this.child.setBeginTag(child);

				p = "\\"+child.trim()+"([\\s\\S]*)\\"+child.replace("{ms:", "{/").trim()+"}";
				r = Pattern.compile(p);
				m = r.matcher(content);
				while (m.find()) {
					this.child.setContent(m.group());
				}
			}

		}
		return this.child;
	}

	public void setChild(TagBean child) {
		this.child = child;
	}
	

}
