package net.mingsoft.mdiy.util;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;

import cn.hutool.core.io.FileUtil;
import freemarker.cache.FileTemplateLoader;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.MalformedTemplateNameException;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateNotFoundException;
import net.mingsoft.base.constant.Const;
import net.mingsoft.basic.util.BasicUtil;
import net.mingsoft.mdiy.parser.TagParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserUtil {
	/*
	 * log4j日志记录
	 */
	protected final static Logger LOG = LoggerFactory.getLogger(ParserUtil.class);
	/**
	 * 存放模版的文件夹
	 */
	public static final String TEMPLATES = "templets";
	/**
	 * 静态文件生成路径;例如：mcms/html/1
	 */
	public static final String HTML = "html";
	/**
	 * 移动端生成的目录
	 */
	public static final String MOBILE = "m";
	/**
	 * index
	 */
	public static final String INDEX = "index";

	/**
	 * 文件夹路径名;例如：1/58/71.html
	 */
	public static final String HTML_SUFFIX = ".html";
	/**
	 * 生成的静态列表页面名;例如：list1.html
	 */
	public static final String PAGE_LIST = "list-";
	/**
	 * 模版文件后缀名;例如：index.html
	 */
	public static final String HTM_SUFFIX = ".htm";
	
	/**
	 * 是否是动态解析;true:动态、false：静态
	 */
	public static final String IS_DO = "isDo";
	
	/**
	 * 当前系统访问路径
	 */
	public static final String URL = "url";
	
	/**
	 * 栏目实体;
	 */
	public static final String COLUMN = "column";
	
	/**
	 * 文章编号
	 */
	public static final String ID = "id";
	
	
	/**
	 * 自定义模型表名;
	 */
	public static final String TABLE_NAME = "tableName";
	
	/**
	 * 模块路径;
	 */
	public static final String MODEL_NAME = "modelName";
	
	/**
	 * .do后缀
	 */
	public static final String DO_SUFFIX = ".do";
	
	/**
	 * 分页，提供給解析传递给sql解析使用
	 */
	public static final String PAGE = "pageTag";
	
	/**
	 * 当前页;
	 */
	public static final String PAGE_NO = "pageNo";
	
	/**
	 * 显示的条数;文章列表属性
	 */
	public static final String SIZE = "size";
	
	/**
	 * 栏目编号;原标签没有使用驼峰命名
	 */
	public static final String TYPE_ID = "typeid";
	
	/**
	 * 站点编号
	 */
	public static final String APP_ID = "appId";
	
	/**
	 * 单站点
	 */
	public static boolean IS_SINGLE = true;
	
	public static Configuration cfg = new Configuration();

	public static FileTemplateLoader ftl = null;



	/**
	 * 拼接模板文件路径
	 * 
	 * @return
	 */
	public static String buildTempletPath() {
		return ParserUtil.buildTempletPath(null);
	}

	/**
	 * 拼接模板文件路径
	 * 
	 * @return
	 */
	public static String buildTempletPath(String path) {
		return BasicUtil.getRealPath(TEMPLATES) + File.separator + BasicUtil.getAppId() + File.separator
				+ BasicUtil.getApp().getAppStyle() + (path != null ? (File.separator + path) : "");
	}

	/**
	 * 拼接移动端生成后的地址
	 * 
	 * @return
	 */
	public static String buildMobileHtmlPath(String path) {
		return BasicUtil.getRealPath(HTML) + File.separator + BasicUtil.getAppId() + File.separator + MOBILE
				+ File.separator + path + HTML_SUFFIX;
	}

	/**
	 * 拼接生成后的路径地址
	 * 
	 * @return
	 */
	public static String buildHtmlPath(String path) {
		return BasicUtil.getRealPath(HTML) + File.separator + BasicUtil.getAppId() + File.separator + path
				+ HTML_SUFFIX;
	}
	
	/**
	 * 判断是否移动端模版文件
	 * path 模版文件名
	 * @return
	 */
	public static boolean hasMobileFile(String path) {
		if(FileUtil.exist(ParserUtil.buildTempletPath(ParserUtil.MOBILE+File.separator+path))){
			return true;
		}
		return false;
	}
	
	/**
	 * 根据模板路径，参数生成，主要提供给动态解析模板内容
	 * 
	 * @param templatePath
	 *            模板路径
	 * @param params
	 *            参数
	 * @param isMobile
	 *            是否是移动端
	 * @return
	 * @throws TemplateNotFoundException
	 * @throws MalformedTemplateNameException
	 * @throws ParseException
	 * @throws IOException
	 */
	public static String generate(String templatePath, Map params, boolean isMobile)
			throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
		//如果单站点，就废弃站点地址
		if(ParserUtil.IS_SINGLE) {
			params.put(URL, BasicUtil.getUrl());
		}
		//设置生成的路径
		params.put(HTML, HTML);
		//设置站点编号
		params.put(APP_ID, BasicUtil.getAppId());
		if (ftl == null || !ParserUtil.buildTempletPath().equals(ftl.baseDir.getPath())) {
			ftl = new FileTemplateLoader(new File(ParserUtil.buildTempletPath()));
			cfg.setNumberFormat("#");
			cfg.setTemplateLoader(ftl);
		}
		// 读取模板文件
		Template template = cfg.getTemplate((isMobile ? (BasicUtil.getApp().getAppMobileStyle() + File.separator) : "") + templatePath, Const.UTF8);
		// pc端内容
		StringWriter writer = new StringWriter();
		TagParser tag = null;
		String content = null;
		try {
			template.process(null, writer);
			tag = new TagParser(writer.toString(), params);
			content = tag.rendering();
			return content;
		} catch (TemplateException e) {
			e.printStackTrace();
			LOG.error("错误",e);
		}
		return null;
	}
	
	/**
	 * 读取模板内容
	 * @param templatePath
	 * @param isMobile
	 * @return
	 * @throws TemplateNotFoundException
	 * @throws MalformedTemplateNameException
	 * @throws ParseException
	 * @throws IOException
	 */
	public static String read(String templatePath, boolean isMobile)
			throws TemplateNotFoundException, MalformedTemplateNameException, ParseException, IOException {
		if (ftl == null || !ParserUtil.buildTempletPath().equals(ftl.baseDir.getPath())) {
			ftl = new FileTemplateLoader(new File(ParserUtil.buildTempletPath()));
			cfg.setNumberFormat("#");
			cfg.setTemplateLoader(ftl);
		}
		// 读取模板文件
		Template template = cfg.getTemplate((isMobile ? (BasicUtil.getApp().getAppMobileStyle() + File.separator) : "") + templatePath, Const.UTF8);
		// pc端内容
		StringWriter writer = new StringWriter();
		TagParser tag = null;
		String content = null;
		try {
			template.process(null, writer);
			return writer.toString();
		} catch (TemplateException e) {
			LOG.error("错误",e);
			e.printStackTrace();
		}
		return null;
	}
}
