/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.infrastructure;

import com.oracle.graal.pointsto.constraints.UnresolvedElementException;
import com.oracle.graal.pointsto.infrastructure.ConstantPoolPatch;
import com.oracle.graal.pointsto.infrastructure.Universe;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaMethod;
import com.oracle.graal.pointsto.infrastructure.WrappedJavaType;
import com.oracle.graal.pointsto.infrastructure.WrappedSignature;
import com.oracle.graal.pointsto.util.AnalysisError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.BootstrapMethodIntrospection;
import org.graalvm.compiler.debug.GraalError;

public class WrappedConstantPool
implements ConstantPool,
ConstantPoolPatch {
    protected final Universe universe;
    protected final ConstantPool wrapped;
    private final WrappedJavaType defaultAccessingClass;
    private static final Method hsLoadReferencedType;
    private static final Method hsLookupReferencedType;
    private static final Method hsLookupBootstrapMethodInvocation;
    private static final Method lookupMethodWithCaller;
    private static final Method bsmGetMethod;
    private static final Method bsmIsInvokeDynamic;
    private static final Method bsmGetName;
    private static final Method bsmGetType;
    private static final Method bsmGetStaticArguments;

    public WrappedConstantPool(Universe universe, ConstantPool wrapped, WrappedJavaType defaultAccessingClass) {
        this.universe = universe;
        this.wrapped = wrapped;
        this.defaultAccessingClass = defaultAccessingClass;
    }

    public int length() {
        return this.wrapped.length();
    }

    public static void loadReferencedType(ConstantPool cp, int cpi, int opcode, boolean initialize) {
        ConstantPool root = cp;
        while (root instanceof WrappedConstantPool) {
            root = ((WrappedConstantPool)root).wrapped;
        }
        try {
            hsLoadReferencedType.invoke((Object)root, cpi, opcode, initialize);
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                cause = ex.getCause();
                if (cause instanceof BootstrapMethodError && cause.getCause() != null) {
                    cause = cause.getCause();
                }
            } else if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public void loadReferencedType(int cpi, int opcode) {
        WrappedConstantPool.loadReferencedType(this.wrapped, cpi, opcode, false);
    }

    public JavaField lookupField(int cpi, ResolvedJavaMethod method, int opcode) {
        ResolvedJavaMethod substMethod = this.universe.resolveSubstitution(((WrappedJavaMethod)method).getWrapped());
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupField(cpi, substMethod, opcode));
    }

    public JavaMethod lookupMethod(int cpi, int opcode) {
        return this.universe.lookupAllowUnresolved(this.wrapped.lookupMethod(cpi, opcode));
    }

    @Override
    public JavaMethod lookupMethod(int cpi, int opcode, ResolvedJavaMethod caller) {
        if (lookupMethodWithCaller == null) {
            return this.lookupMethod(cpi, opcode);
        }
        try {
            ResolvedJavaMethod substCaller = this.universe.resolveSubstitution(((WrappedJavaMethod)caller).getWrapped());
            return this.universe.lookupAllowUnresolved((JavaMethod)lookupMethodWithCaller.invoke((Object)this.wrapped, cpi, opcode, substCaller));
        }
        catch (Throwable ex) {
            Throwable cause = ex;
            if (ex instanceof InvocationTargetException && ex.getCause() != null) {
                cause = ex.getCause();
            } else if (ex instanceof ExceptionInInitializerError && ex.getCause() != null) {
                cause = ex.getCause();
            }
            throw new UnresolvedElementException("Error loading a referenced type: " + cause.toString(), cause);
        }
    }

    public JavaMethod lookupMethodInWrapped(int cpi, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupMethodInWrapped(cpi, opcode);
        }
        return this.wrapped.lookupMethod(cpi, opcode);
    }

    public JavaType lookupTypeInWrapped(int cpi, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupTypeInWrapped(cpi, opcode);
        }
        return this.wrapped.lookupType(cpi, opcode);
    }

    public JavaField lookupFieldInWrapped(int cpi, ResolvedJavaMethod method, int opcode) {
        if (this.wrapped instanceof WrappedConstantPool) {
            return ((WrappedConstantPool)this.wrapped).lookupFieldInWrapped(cpi, method, opcode);
        }
        return this.wrapped.lookupField(cpi, method, opcode);
    }

    public JavaType lookupType(int cpi, int opcode) {
        try {
            return this.universe.lookupAllowUnresolved(this.wrapped.lookupType(cpi, opcode));
        }
        catch (AnalysisError.TypeNotFoundError e) {
            return null;
        }
    }

    public WrappedSignature lookupSignature(int cpi) {
        return this.universe.lookup(this.wrapped.lookupSignature(cpi), this.defaultAccessingClass);
    }

    public JavaConstant lookupAppendix(int cpi, int opcode) {
        return this.universe.lookup(this.wrapped.lookupAppendix(cpi, opcode));
    }

    public String lookupUtf8(int cpi) {
        return this.wrapped.lookupUtf8(cpi);
    }

    public Object lookupConstant(int cpi) {
        Object con = this.wrapped.lookupConstant(cpi);
        if (con instanceof JavaType) {
            if (con instanceof ResolvedJavaType) {
                return this.universe.lookup((JavaType)((ResolvedJavaType)con));
            }
            return con;
        }
        if (con instanceof JavaConstant) {
            return this.universe.lookup((JavaConstant)con);
        }
        throw JVMCIError.unimplemented();
    }

    @Override
    public JavaType lookupReferencedType(int index, int opcode) {
        if (hsLookupReferencedType != null) {
            try {
                JavaType type = null;
                if (this.wrapped instanceof WrappedConstantPool) {
                    type = ((WrappedConstantPool)this.wrapped).lookupReferencedType(index, opcode);
                } else {
                    try {
                        type = (JavaType)hsLookupReferencedType.invoke((Object)this.wrapped, index, opcode);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (type != null) {
                    return this.universe.lookupAllowUnresolved(type);
                }
            }
            catch (AnalysisError.TypeNotFoundError typeNotFoundError) {
                // empty catch block
            }
        }
        return null;
    }

    public BootstrapMethodIntrospection lookupBootstrapMethodIntrospection(int cpi, int opcode) {
        if (hsLookupBootstrapMethodInvocation != null) {
            try {
                Object bootstrapMethodInvocation = hsLookupBootstrapMethodInvocation.invoke((Object)this.wrapped, cpi, opcode);
                return new WrappedBootstrapMethodInvocation(bootstrapMethodInvocation);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    static {
        try {
            Class<?> hsConstantPool = Class.forName("jdk.vm.ci.hotspot.HotSpotConstantPool");
            hsLoadReferencedType = ReflectionUtil.lookupMethod(hsConstantPool, (String)"loadReferencedType", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, Boolean.TYPE});
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException ex) {
            throw GraalError.shouldNotReachHere((String)"JVMCI 0.47 or later, or JDK 11 is required for Substrate VM: could not find method HotSpotConstantPool.loadReferencedType");
        }
        Method lookupReferencedType = null;
        try {
            Class<?> hsConstantPool = Class.forName("jdk.vm.ci.hotspot.HotSpotConstantPool");
            lookupReferencedType = ReflectionUtil.lookupMethod(hsConstantPool, (String)"lookupReferencedType", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException hsConstantPool) {
            // empty catch block
        }
        hsLookupReferencedType = lookupReferencedType;
        Method lookupBootstrapMethodInvocation = null;
        try {
            Class<?> hsConstantPool = Class.forName("jdk.vm.ci.hotspot.HotSpotConstantPool");
            lookupBootstrapMethodInvocation = ReflectionUtil.lookupMethod(hsConstantPool, (String)"lookupBootstrapMethodInvocation", (Class[])new Class[]{Integer.TYPE, Integer.TYPE});
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException hsConstantPool) {
            // empty catch block
        }
        hsLookupBootstrapMethodInvocation = lookupBootstrapMethodInvocation;
        lookupMethodWithCaller = ReflectionUtil.lookupMethod((boolean)true, ConstantPool.class, (String)"lookupMethod", (Class[])new Class[]{Integer.TYPE, Integer.TYPE, ResolvedJavaMethod.class});
        Method getMethod = null;
        Method isInvokeDynamic = null;
        Method getName = null;
        Method getType = null;
        Method getStaticArguments = null;
        try {
            Class<?> bootstrapMethodInvocation = Class.forName("jdk.vm.ci.meta.ConstantPool$BootstrapMethodInvocation");
            getMethod = ReflectionUtil.lookupMethod(bootstrapMethodInvocation, (String)"getMethod", (Class[])new Class[0]);
            isInvokeDynamic = ReflectionUtil.lookupMethod(bootstrapMethodInvocation, (String)"isInvokeDynamic", (Class[])new Class[0]);
            getName = ReflectionUtil.lookupMethod(bootstrapMethodInvocation, (String)"getName", (Class[])new Class[0]);
            getType = ReflectionUtil.lookupMethod(bootstrapMethodInvocation, (String)"getType", (Class[])new Class[0]);
            getStaticArguments = ReflectionUtil.lookupMethod(bootstrapMethodInvocation, (String)"getStaticArguments", (Class[])new Class[0]);
        }
        catch (ReflectionUtil.ReflectionUtilError | ClassNotFoundException throwable) {
            // empty catch block
        }
        bsmGetMethod = getMethod;
        bsmIsInvokeDynamic = isInvokeDynamic;
        bsmGetName = getName;
        bsmGetType = getType;
        bsmGetStaticArguments = getStaticArguments;
    }

    public class WrappedBootstrapMethodInvocation
    implements BootstrapMethodIntrospection {
        private final Object wrapped;

        public WrappedBootstrapMethodInvocation(Object wrapped) {
            this.wrapped = wrapped;
        }

        public ResolvedJavaMethod getMethod() {
            if (bsmGetMethod != null) {
                try {
                    return WrappedConstantPool.this.universe.lookup((JavaMethod)((ResolvedJavaMethod)bsmGetMethod.invoke(this.wrapped, new Object[0])));
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        public boolean isInvokeDynamic() {
            if (bsmIsInvokeDynamic != null) {
                try {
                    return (Boolean)bsmIsInvokeDynamic.invoke(this.wrapped, new Object[0]);
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        public String getName() {
            if (bsmGetName != null) {
                try {
                    return (String)bsmGetName.invoke(this.wrapped, new Object[0]);
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        public JavaConstant getType() {
            if (bsmGetType != null) {
                try {
                    return WrappedConstantPool.this.universe.lookup((JavaConstant)bsmGetType.invoke(this.wrapped, new Object[0]));
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere();
        }

        public List<JavaConstant> getStaticArguments() {
            if (bsmGetStaticArguments != null) {
                try {
                    List original = (List)bsmGetStaticArguments.invoke(this.wrapped, new Object[0]);
                    return original.stream().map(e -> WrappedConstantPool.this.universe.lookup((JavaConstant)e)).collect(Collectors.toList());
                }
                catch (Throwable t) {
                    throw GraalError.shouldNotReachHere((Throwable)t);
                }
            }
            throw GraalError.shouldNotReachHere();
        }
    }
}

