/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.util;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class AtomicUtils {
    public static <T> boolean atomicMark(T holder, AtomicIntegerFieldUpdater<T> updater) {
        return updater.compareAndSet(holder, 0, 1);
    }

    public static <T> boolean atomicMarkAndRun(T holder, AtomicIntegerFieldUpdater<T> updater, Runnable task) {
        boolean firstAttempt = updater.compareAndSet(holder, 0, 1);
        if (firstAttempt) {
            task.run();
        }
        return firstAttempt;
    }

    public static <T> boolean isSet(T holder, AtomicIntegerFieldUpdater<T> updater) {
        return updater.get(holder) == 1;
    }

    public static boolean atomicMark(AtomicBoolean flag) {
        return flag.compareAndSet(false, true);
    }

    public static boolean atomicMarkAndRun(AtomicBoolean flag, Runnable task) {
        boolean firstAttempt = flag.compareAndSet(false, true);
        if (firstAttempt) {
            task.run();
        }
        return firstAttempt;
    }

    public static <T> T produceAndSetValue(AtomicReference<T> reference, Supplier<T> supplier, Consumer<T> initializer) {
        T value;
        if (reference.get() == null && reference.compareAndSet(null, value = supplier.get())) {
            initializer.accept(value);
        }
        return reference.get();
    }
}

