package com.mini.framework.third.weixin.console;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.third.weixin.console.model.WeixinCurlCommand;
import com.mini.framework.util.http.linked.HttpClientHelper;
import com.mini.framework.util.http.linked.HttpMethod;
import com.mini.framework.util.http.linked.HttpRequest;
import com.mini.framework.util.http.linked.HttpResponse;
import com.mini.framework.util.string.RegexUtil;


/**
 * 微信服务号控制台的代理命令
 * @author jayheo
 *
 */
public class ConsoleProxyCommandHelper {

	/**
	 * <pre>
	 * 如果要使用这命令如何获得参数呢
	 * 1，使用google 进入 https://mp.weixin.qq.com/
	 * 2，使用正常的途径登录。
	 * 3，打开F12 进入调试模式里面的 Network (使用all)
	 * 4，找到目标请求   
	 * 5，依次: 右击鼠标->选择复制(Copy)->Copy as cURL(bash)
	 * 如果内容就会被复制到剪切板上了。
	 * </pre>
	 * 
	 * @param command
	 * @return
	 */
	public static WeixinCurlCommand parseBachCurl(String command){
		String[] items = command.split(" \\-H ");
		String url = null;
		String cookie = null;
		for (String item : items) {
			String cookieTemp = RegexUtil.getMatch("'cookie:(.*)'", item,1);
			if(cookieTemp!=null){
				cookie = cookieTemp;
			}
			String urlTemp = RegexUtil.getMatch(".*curl.*'(.*)'", item,1);
			if(urlTemp!=null){
				url = urlTemp;
			}
		}
		if(cookie!=null &&url!=null){
			return new WeixinCurlCommand(url,cookie);
		}else{
			throw new BadReqException("命令中解析不出url[%s]和cookie:[%s],command:[%s]",url,cookie, command);
		}
	}
	
	
	/**
	 * 需要看具体怎么拿到命令
	 * @see ConsoleProxyCommandHelper#parseBachCurl(String)
	 * @param command
	 * @return
	 */
	public static String exeBachCurl(String command){
		WeixinCurlCommand request = parseBachCurl(command);
		return exeUseUrlAndCookie(request.getUrl(), request.getCookie());
	}
	
	public static String exeUseUrlAndCookie(String url,String cookie){
		HttpRequest request = HttpRequest.create()
				.url(url).header("cookie", cookie).method(HttpMethod.get);
		HttpResponse response = HttpClientHelper.execute(request);
		return response.getBodyString();
	}
	
}
