package com.mini.framework.third.weixin.mapp.model.template;

import java.util.LinkedHashMap;

import com.google.gson.annotations.SerializedName;

/**
 * 需要发送的模板消息的消息体
 * 
 * @author jayheo
 *
 */
public class MessageSendBodyRequest {

	/**
	 * 接收者（用户）的 openid
	 */
	@SerializedName("touser")
	private String openid;

	/**
	 * 所需下发的模板消息的id
	 */
	@SerializedName("template_id")
	private String templateKey;

	/**
	 * 点击模板卡片后的跳转页面，仅限本小程序内的页面。支持带参数,（示例index?foo=bar）。该字段不填则模板无跳转。
	 */
	@SerializedName("page")
	private String namespace;

	/**
	 * 表单提交场景下，为 submit 事件带上的 formId；支付场景下，为本次支付的 prepay_id
	 */
	@SerializedName("form_id")
	private String sendToken;

	/**
	 * 模板需要放大的关键词，不填则默认无放大
	 */
	@SerializedName("emphasis_keyword")
	private String importantKeywordKeys;

	@SerializedName("data")
	private LinkedHashMap<String, MessageParam> params;

	public String getOpenid() {
		return openid;
	}

	public void setOpenid(String openid) {
		this.openid = openid;
	}

	public String getTemplateKey() {
		return templateKey;
	}

	public void setTemplateKey(String templateKey) {
		this.templateKey = templateKey;
	}

	public String getNamespace() {
		return namespace;
	}

	public void setNamespace(String namespace) {
		this.namespace = namespace;
	}

	public String getSendToken() {
		return sendToken;
	}

	public void setSendToken(String sendToken) {
		this.sendToken = sendToken;
	}

	public String getImportantKeywordKeys() {
		return importantKeywordKeys;
	}

	public void setImportantKeywordKeys(String importantKeywordKeys) {
		this.importantKeywordKeys = importantKeywordKeys;
	}

	public LinkedHashMap<String, MessageParam> getParams() {
		return params;
	}

	public void setParams(LinkedHashMap<String, MessageParam> params) {
		this.params = params;
	}

}
