package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453
<xml><ToUserName>< ![CDATA[toUser] ]></ToUserName><FromUserName>< ![CDATA[fromUser] ]></FromUserName><CreateTime>1351776360</CreateTime><MsgType>< ![CDATA[location] ]></MsgType><Location_X>23.134521</Location_X><Location_Y>113.358803</Location_Y><Scale>20</Scale><Label>< ![CDATA[位置信息] ]></Label><MsgId>1234567890123456</MsgId></xml>

<xml><ToUserName><![CDATA[gh_5f8a403a7e91]]></ToUserName>
<FromUserName><![CDATA[oDmGI1T65oFagp_oWWNz-KMOfaZE]]></FromUserName>
<CreateTime>1522052588</CreateTime>
<MsgType><![CDATA[location]]></MsgType>
<Location_X>28.230141</Location_X>
<Location_Y>112.876518</Location_Y>
<Scale>16</Scale>
<Label><![CDATA[湖南省长沙市岳麓区岳麓大道588号芯城科技园10栋101号]]></Label>
<MsgId>6537166088696401170</MsgId>
</xml>


参数	描述
ToUserName	开发者微信号
FromUserName	发送方帐号（一个OpenID）
CreateTime	消息创建时间 （整型）
MsgType	location
Location_X	地理位置维度
Location_Y	地理位置经度
Scale	地图缩放大小
Label	地理位置信息
MsgId	消息id，64位整型

*/
/**
 * 微信地理位置消息的通知
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class LocationNotice extends WeixinNotice{
	
	
	/**
	 * 纵坐标
	 */
	@XStreamAlias("Location_Y")
	private double yaxis;
	/**
	 * 横坐标
	 */
	@XStreamAlias("Location_X")
	private double xaxis;
	
	/**
	 * 地图缩放大小
	 */
	@XStreamAlias("Scale")
	private double scale;
	
	/**
	 * 地理位置信息
	 */
	@XStreamAlias("Label")
	private String label;

	public double getYaxis() {
		return yaxis;
	}

	public void setYaxis(double yaxis) {
		this.yaxis = yaxis;
	}

	public double getXaxis() {
		return xaxis;
	}

	public void setXaxis(double xaxis) {
		this.xaxis = xaxis;
	}

	public double getScale() {
		return scale;
	}

	public void setScale(double scale) {
		this.scale = scale;
	}

	public String getLabel() {
		return label;
	}

	public void setLabel(String label) {
		this.label = label;
	}
	
}
