package com.mini.framework.third.weixin.pay.client;

import org.simpleframework.xml.Element;

import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 标准的通讯报文
 * @author jayheo
 *
 */
public abstract class ConnMessage implements MessageMd5Signable{
	
    @XStreamAlias("appid")
    @Element(name = "appid",required = false)
    private String appid;

    @XStreamAlias("mch_id")
    @Element(name = "mch_id", required = false)
    private String mchId;

    @Element(name = "mchId",required = false)
    @XStreamAlias("mchid")
    private String mchId4mch;

    @Element(name = "mch_appid",required = false)
    @XStreamAlias("mch_appid")
    private String mchAppid;

    @XStreamAlias("nonce_str")
    @Element(name = "nonce_str", required = false)
    private String nonceStr;

    @XStreamAlias("sign")
    @Element(name = "sign", required = false)
    private String sign;

	public String getAppid() {
		return appid;
	}

	public void setAppid(String appid) {
		this.appid = appid;
	}

	public String getMchId() {
		return mchId;
	}

	public void setMchId(String mchId) {
		this.mchId = mchId;
	}

	public String getNonceStr() {
		return nonceStr;
	}

	public void setNonceStr(String nonceStr) {
		this.nonceStr = nonceStr;
	}

	public String getSign() {
		return sign;
	}

	public void setSign(String sign) {
		this.sign = sign;
	}

	public String getMchId4mch() {
		return mchId4mch;
	}

	public void setMchId4mch(String mchId4mch) {
		this.mchId4mch = mchId4mch;
	}

	public String getMchAppid() {
		return mchAppid;
	}

	public void setMchAppid(String mchAppid) {
		this.mchAppid = mchAppid;
	}

	@Override
	public String showSign() {
		return this.getSign();
	}

	@Override
	public void fillSign(String sign) {
		this.setSign(sign);
	}

}