package com.mini.framework.third.weixin.server.model;

import java.util.Date;

import com.google.gson.annotations.SerializedName;

/*
 * 
 https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140839
{
    "subscribe": 1, 
    "openid": "o6_bmjrPTlm6_2sgVt7hMZOPfL2M", 
    "nickname": "Band", 
    "sex": 1, 
    "language": "zh_CN", 
    "city": "广州", 
    "province": "广东", 
    "country": "中国", 
    "headimgurl":"http://thirdwx.qlogo.cn/mmopen/g3MonUZtNHkdmzicIlibx6iaFqAc56vxLSUfpb6n5WKSYVY0ChQKkiaJSgQ1dZuTOgvLLrhJbERQQ4eMsv84eavHiaiceqxibJxCfHe/0",
    "subscribe_time": 1382694957,
    "unionid": " o6_bmasdasdsad6_2sgVt7hMZOPfL"
    "remark": "",
    "groupid": 0,
    "tagid_list":[128,2],
    "subscribe_scene": "ADD_SCENE_QR_CODE",
    "qr_scene": 98765,
    "qr_scene_str": ""
}
 * */

/**
 * 微信服务号用户详情
 * 
 * @author jayheo
 *
 */
public class WeixinServerUserDetail extends WeixinBaseUserDetail {

	/**
	 * 
	 */
	private static final long serialVersionUID = -8361378254331127312L;

	/**
	 * subscribe 用户是否订阅该公众号标识，值为0时，代表此用户没有关注该公众号，拉取不到其余信息。
	 * */
	@SerializedName("subscribe")
	private Integer subscribe;

	/**
	 * subscribe_time 用户关注时间，为时间戳。如果用户曾多次关注，则取最后关注时间
	 */
	@SerializedName("subscribe_time")
	private Date lastSubDate;

	/**
	 * remark 公众号运营者对粉丝的备注，公众号运营者可在微信公众平台用户管理界面对粉丝添加备注
	 */
	@SerializedName("remark")
	private String remark;

	/**
	 * groupid	用户所在的分组ID（兼容旧的用户分组接口）
	 */
	@SerializedName("groupid")
	private Integer groupid;

	/**
	 * tagid_list 用户被打上的标签ID列表
	 */
	@SerializedName("tagid_list")
	private int[] tagids;

	/**
	 * subscribe_scene 返回用户关注的渠道来源，ADD_SCENE_SEARCH
	 * 公众号搜索，ADD_SCENE_ACCOUNT_MIGRATION 公众号迁移，ADD_SCENE_PROFILE_CARD
	 * 名片分享，ADD_SCENE_QR_CODE 扫描二维码，ADD_SCENEPROFILE LINK
	 * 图文页内名称点击，ADD_SCENE_PROFILE_ITEM 图文页右上角菜单，ADD_SCENE_PAID
	 * 支付后关注，ADD_SCENE_OTHERS 其他
	 */
	@SerializedName("subscribe_scene")
	private String subReferer;

	// qr_scene 二维码扫码场景（开发者自定义） 这个没有使用

	/**
	 * qr_scene_str 二维码扫码场景描述（开发者自定义）
	 */
	@SerializedName("qr_scene_str")
	private String qrSceneCode;
	

	public Integer getSubscribe() {
		return subscribe;
	}

	public void setSubscribe(Integer subscribe) {
		this.subscribe = subscribe;
	}

	public Date getLastSubDate() {
		return lastSubDate;
	}

	public void setLastSubDate(Date lastSubDate) {
		this.lastSubDate = lastSubDate;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Integer getGroupid() {
		return groupid;
	}

	public void setGroupid(Integer groupid) {
		this.groupid = groupid;
	}

	public int[] getTagids() {
		return tagids;
	}

	public void setTagids(int[] tagids) {
		this.tagids = tagids;
	}

	public String getSubReferer() {
		return subReferer;
	}

	public void setSubReferer(String subReferer) {
		this.subReferer = subReferer;
	}

	public String getQrSceneCode() {
		return qrSceneCode;
	}

	public void setQrSceneCode(String qrSceneCode) {
		this.qrSceneCode = qrSceneCode;
	}

	/**
	 * 是不是关注了
	 * @return
	 */
	@Deprecated
	public boolean haveSub(){
		return haveSubscribe();
	}
	public boolean haveSubscribe(){
		return subscribe!=null && subscribe==1;
	}
	
}
