/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.kuaidi100.model;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.express.model.ExpressTransportStage;
import com.mini.framework.third.express.model.ExpressTransportStatus;
import com.mini.framework.third.express.model.ExpressTransportStatusItem;
import com.mini.framework.third.kuaidi100.model.AbstractResponse;
import com.mini.framework.third.kuaidi100.model.StatusItem;
import com.mini.framework.util.function.PredicateSpread;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ExpressStatusResponse
extends AbstractResponse {
    private Integer state;
    @SerializedName(value="ischeck")
    private Integer recept;
    @SerializedName(value="com")
    private String company;
    @SerializedName(value="nu")
    private String number;
    @SerializedName(value="data")
    private List<StatusItem> stateItems;

    public Integer getState() {
        return this.state;
    }

    public void setState(Integer state) {
        this.state = state;
    }

    public Integer getRecept() {
        return this.recept;
    }

    public void setRecept(Integer recept) {
        this.recept = recept;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getNumber() {
        return this.number;
    }

    public void setNumber(String number) {
        this.number = number;
    }

    public List<StatusItem> getStateItems() {
        return this.stateItems;
    }

    public void setStateItems(List<StatusItem> stateItems) {
        this.stateItems = stateItems;
    }

    public static ExpressStatusResponse fromJson(String json) {
        return ExpressStatusResponse.fromJson(ExpressStatusResponse.class, json);
    }

    public ExpressTransportStatus mapperExpressTransportStatus() {
        ExpressTransportStatus transportStatus = new ExpressTransportStatus();
        transportStatus.setOriginalBody(this.getRespOriginal());
        transportStatus.setNumber(this.number);
        transportStatus.setOperateMarketCode(this.company);
        if (this.state != null) {
            transportStatus.setCurrStatus(ExpressTransportStage.fromKuaidi100Code(this.state).orElse(null));
        }
        if (this.stateItems != null) {
            List<ExpressTransportStatusItem> items = this.stateItems.stream().map(StatusItem::mapperExpressTransport).sorted(Comparator.comparing(ExpressTransportStatusItem::getDate)).collect(Collectors.toList());
            items.stream().findFirst().ifPresent(item -> item.setStage(ExpressTransportStage.activation));
            transportStatus.setItems(items);
            items.stream().filter(PredicateSpread.of(ExpressTransportStatusItem::hasStage).negate()).forEach(item -> item.setStage(ExpressTransportStage.progress));
            transportStatus.setCurrDate(transportStatus.lastItemDate().orElse(null));
        }
        return transportStatus;
    }
}

