/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.string.StringUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.RandomStringUtils;

public class ServerJsapiTicketResponse {
    private String url;
    private String ticket;
    private String nonceStr;
    private String signature;
    private String timestamp;
    private String appid;

    public ServerJsapiTicketResponse(String url, String ticket, String appid) {
        this.nonceStr = RandomStringUtils.randomNumeric((int)16);
        this.timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        this.url = url;
        this.ticket = ticket;
        this.appid = appid;
    }

    public ServerJsapiTicketResponse() {
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getTicket() {
        return this.ticket;
    }

    public void setTicket(String ticket) {
        this.ticket = ticket;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public ServerJsapiTicketResponse sign() {
        String params = String.format("jsapi_ticket=%s&noncestr=%s&timestamp=%s&url=%s", this.ticket, this.nonceStr, this.timestamp, this.url);
        MessageDigest crypt = this.createSHA1Digest();
        crypt.reset();
        crypt.update(StringUtil.getUtf8Byte((String)params));
        this.signature = Hex.encodeHexString((byte[])crypt.digest());
        return this;
    }

    private MessageDigest createSHA1Digest() {
        try {
            return MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u53d6SHA-1\u51fa\u73b0\u5f02\u5e38", new Object[0]);
        }
    }
}

