/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.JsApiCreatePayOrderResponse;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;

public class JsApiWebJsRequestBean {
    @SerializedName(value="appId")
    private String appid;
    @SerializedName(value="timeStamp")
    private String secondTimestamp;
    private String nonceStr;
    @SerializedName(value="package")
    private String packageName;
    @SerializedName(value="signType")
    private String signatureType;
    @SerializedName(value="paySign")
    private String signatureResult;

    public static JsApiWebJsRequestBean fromPayOrderResponse(JsApiCreatePayOrderResponse response) {
        JsApiWebJsRequestBean instance = new JsApiWebJsRequestBean();
        instance.packageName = String.format("prepay_id=%s", response.getPackageId());
        instance.appid = response.getRequest().getAppid();
        instance.secondTimestamp = String.valueOf(System.currentTimeMillis() / 1000L);
        instance.nonceStr = RandomStringUtils.randomAlphanumeric((int)20);
        instance.signatureType = "RSA";
        return instance;
    }

    public JsApiWebJsRequestBean signatureThenFillResult(String content) {
        String message = Stream.of(this.appid, this.secondTimestamp, this.nonceStr, this.packageName).collect(Collectors.joining("\n", "", "\n"));
        this.signatureResult = WxpayMarketCertificateContainer.signatureThenBase64Message(message, content);
        return this;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getSecondTimestamp() {
        return this.secondTimestamp;
    }

    public void setSecondTimestamp(String secondTimestamp) {
        this.secondTimestamp = secondTimestamp;
    }

    public String getNonceStr() {
        return this.nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSignatureType() {
        return this.signatureType;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    public String getSignatureResult() {
        return this.signatureResult;
    }

    public void setSignatureResult(String signatureResult) {
        this.signatureResult = signatureResult;
    }
}

