package com.mini.framework.third.aliyun.model;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.util.string.GsonUtil;

public class AbstractAliyunResponse {

	@SerializedName("code")
	private Integer code;
	
	@SerializedName("msg")
	private String msg;
	
	@SerializedName("requestId")
	private String requestId;
	
	private String respOriginal;

	public Integer getCode() {
		return code;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public String getRequestId() {
		return requestId;
	}

	public void setRequestId(String requestId) {
		this.requestId = requestId;
	}
	
	
	
	public String getRespOriginal() {
		return respOriginal;
	}

	public void setRespOriginal(String respOriginal) {
		this.respOriginal = respOriginal;
	}

	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
	
	public static <T extends AbstractAliyunResponse> T fromJson(Class<T> clazz,String json){
		T resp = GsonUtil.buildMilliSecondDateGson().fromJson(json, clazz);
		resp.setRespOriginal(json);
		return resp;
	}
	
	
}
