package com.mini.framework.third.weixin.console.server.handler;

import java.util.List;
import java.util.Set;

import com.mini.framework.third.weixin.console.server.model.template.Document;
import com.mini.framework.third.weixin.console.server.model.template.SyncItemResultType;

public interface TemplateSyncHandler {

	/**
	 * 查询到地本存在的文档根据keys
	 * @param keys
	 * @return
	 */
	public List<Document> queryLocalDocuments(Set<String>keys);
	
	
	/**
	 * 添加文件到本地
	 */
	public Document addDocument(Document document);
	
	
	/**
	 * 修改本地的文档
	 */
	public Document setDocument(String key,Document document);
	
	/**
	 * 处理某个key之前
	 * @param key
	 */
	public void beforeOneHandle(String key);
	
	/**
	 * 处理某个key之后
	 * @param key
	 * @param oneResult 
	 */
	public void afterOneHandle(String key, SyncItemResultType oneResult);
	
	/**
	 * 准备就绪
	 * @return 返回true就启动，返回false就不启动
	 */
	public boolean readyIfExecute(int itemSize);
	
	
	/**
	 * 完成处理
	 */
	public void endHandle();
	
	
	
}
