package com.mini.framework.third.weixin.mapp.model.template;

import java.util.List;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.mapp.model.AbstractResponse;

/**
 * 模板消息库
 * 
 * @author jayheo
 *
 */
public class MessageTemplateLibraryResponse extends AbstractResponse {

	/**
	 * 总数
	 */
	@SerializedName("total_count")
	private int count;

	/**
	 * 模板
	 */
	@SerializedName("list")
	private List<MessageTemplateResponse> templates;

	public int getCount() {
		return count;
	}

	public void setCount(int count) {
		this.count = count;
	}

	public List<MessageTemplateResponse> getTemplates() {
		return templates;
	}

	public void setTemplates(List<MessageTemplateResponse> templates) {
		this.templates = templates;
	}
	
	public void addTemplates(List<MessageTemplateResponse> templates) {
		this.templates.addAll(templates);
	}

}
