package com.mini.framework.third.weixin.notice.server.model.resp;

import java.util.Optional;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.RegexUtil;
import com.mini.framework.third.weixin.notice.server.model.able.IfHaveInviteCode;
import com.mini.framework.third.weixin.notice.server.model.able.NewSubscribeAble;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * <pre>
 * 能进这里用户都是未关注的。
 * 扫描带参数二维码事件  有ticket
 * 直接打开公众号。无ticket
 * </pre>
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class EventSubscribeNotice extends EventNotice implements IfHaveInviteCode,NewSubscribeAble{
	
	private static Logger logger = LogManager.getLogger(EventSubscribeNotice.class);
	
	//如果是通过扫码来关注的会有这个ticket  用户未关注时，扫描带参数二维码事件
	@XStreamAlias("Ticket")
	private String ticket;

	public String getTicket() {
		return ticket;
	}

	public void setTicket(String ticket) {
		this.ticket = ticket;
	}

	@Override
	public boolean isNewSub() {
		// TODO Auto-generated method stub
		return false;
	}
	
	@Deprecated	
	public String showRightInviteCode(){
		return showSceneCode().orElse(null);
	}
	
	
	public Optional<String> showSceneCode(){
		String rightTicket = null;
		String eventKey = getEventKey();
		if(ticket!=null){
			rightTicket = RegexUtil.getMatch("qrscene_(.+)", eventKey, 1);
		}
		Event5WBuilder event = Event5WBuilder.event(1, "ticketToRight")
				.who("eventKey:[%s]", eventKey).what("被解析成:[%s]", rightTicket).why("去掉前缀qrscene_");
		logger.debug(event);
		return Optional.ofNullable(rightTicket);
	}
	
}
