package com.mini.framework.third.weixin.pay.client;

import com.mini.framework.third.weixin.pay.model.UserMappTransferRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 企业向用户支付请求.
 *
 * @author riefu233
 */
@XStreamAlias("xml")
public class UserMappTransferPreRequest extends ConnMessageRequest implements MessageMd5Signable {

    @XStreamAlias("openid")
    private String openid;

    @XStreamAlias("partner_trade_no")
    private String partnerTradeNo;

    @XStreamAlias("check_name")
    private String checkName = "NO_CHECK";

    @XStreamAlias("amount")
    private Integer amount;

    @XStreamAlias("desc")
    private String desc;

    @XStreamAlias("spbill_create_ip")
    private String spbillCreateIp;


    public UserMappTransferPreRequest(UserMappTransferRequest request) {
        this.amount = request.getAmount();
        this.desc = request.getDesc();
        this.partnerTradeNo = request.getSitePayOrder();
        this.openid = request.getOpenId();
        this.spbillCreateIp = request.getSpbillCreateIp();
    }

    public String getPartnerTradeNo() {
        return partnerTradeNo;
    }

    public void setPartnerTradeNo(String partnerTradeNo) {
        this.partnerTradeNo = partnerTradeNo;
    }

    public String getCheckName() {
        return checkName;
    }

    public void setCheckName(String checkName) {
        this.checkName = checkName;
    }

    public Integer getAmount() {
        return amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getSpbillCreateIp() {
        return spbillCreateIp;
    }

    public void setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    @Override
    public String messageType() {
        return "企业付款至零钱";
    }
}
