package com.mini.framework.third.weixin.server.comm;

import java.util.Date;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.asserts.AssertUtil;

public class AccessTokenResponse extends AbstractResponse{
	@SerializedName("access_token")
	private String token;

	@SerializedName("expires_in")
	private Integer expire;

	public String getToken() {
		return token;
	}

	public void setToken(String token) {
		this.token = token;
	}

	public Integer getExpire() {
		return expire;
	}

	public void setExpire(Integer expire) {
		this.expire = expire;
	}


	/**
	 * @see #summaryExpireDate(Date)
	 * @return
	 */
	@Deprecated
	public Date tokenExpireDate(){
		AssertUtil.simpleAssertByStatus(expire!=null, Status.Third.wxRespForm, "微信的响应格式错误");
		Date tokenExpire = new Date(System.currentTimeMillis() + expire*1000);
		return tokenExpire;
	}


	/**
	 * 得到过期的时间
	 * @param createDate 因为，这个时间是创建的时候为准，所以要求使用者自己传入创建时间，保证正确性
	 * @return 过期的时间
	 */
	public Date summaryExpireDate(Date createDate){
		AssertUtil.simpleAssertByStatus(expire!=null, Status.Third.wxRespForm, "微信的响应格式错误");
		return new Date(createDate.getTime() + expire * 1000L);
	}


}
