package com.mini.framework.third.weixin.wxpay.util.certificate;

import java.io.PrintStream;

/**
 * 证书签名后的处理
 * @author jayheo
 */
public interface HandlerAfterCertificateSignature {


    /**
     * 发现用于header的token
     * @param authToken
     */
    void foundHeaderAuthToken(String authToken);


    /**
     * 填充签名
     * @param signature
     */
    void foundSignature(String signature);


    static HandlerAfterCertificateSignature createByOut(PrintStream out){
        return new HandlerAfterCertificateSignature() {
            @Override
            public void foundHeaderAuthToken(String authToken) {
                out.println(authToken);
            }

            @Override
            public void foundSignature(String signature) {
                out.println(signature);
            }
        };
    }

}
