package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.mini.framework.core.exception.ServerException;
import com.mini.framework.core.status.Status;
import com.mini.framework.util.params.MapParams;

import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;

/**
 * @author jayheo
 */
public class Html5CreatePayOrderResponse extends WxpayResponse implements ClientUsefulCreatePayOrderResponse {


    /**
     * https://wx.tenpay.com/cgi-bin/mmpayweb-bin/checkmweb?prepay_id=wx0519093367660538d320bd9b829f660000&package=4093422734
     * 用户完成支付的url
     * 怎么用这个url ? https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_3_4.shtml
     */
    @SerializedName("h5_url")
    private String userPayUrl;


    private static final String redirectUrlFieldKey = "redirectUrl";

    public String getUserPayUrl() {
        return userPayUrl;
    }

    public void setUserPayUrl(String userPayUrl) {
        this.userPayUrl = userPayUrl;
    }

    @Override
    public String createClientPayRequestJson() {
        MapParams body = MapParams.build()
                .param(redirectUrlFieldKey, userPayUrl)
                .param("domainNote",new String[]{"域名注意事项，"
                        ,"1,h5支付必须是授权内的域名(顶级例:devaqk.com)下某个链接跳转过去才能生效否则会提示:商家参数格式有误，请联系商家解决"
                        ,"2,h5授权的域名配置见链接:https://pay.weixin.qq.com/index.php/extend/pay_setting 登录后可见 见 H5支付域名 那一项"})
                .param("desc"
                        ,new String[]{"使用js重定向可以转到支付页面 redirectUrl 它会自动唤醒微信支付"
                                ,"执行重定向的页面，必须在微信支付的授权页面，否则会报错"
                                ,"对应微信文档的地址是:https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_3_4.shtml"})
                ;
        return ClientUsefulCreatePayOrderResponse.createGsonUtil().toJson(body);
    }

    public static String parseRedirectUrlFromJson(String requestJson){
        Gson gson = ClientUsefulCreatePayOrderResponse.createGsonUtil();
        Type mapType = new TypeToken<Map<String,Object>>(){}.getType();
        Map<String,Object> requestBean = gson.fromJson(requestJson, mapType);
        return Optional.ofNullable(requestBean)
                .map(map->map.get(redirectUrlFieldKey))
                .map(Object::toString)
                .orElseThrow(()->new ServerException(Status.Server.programConfigJava,"requestJson:[%s]中没有找到字符串属性:[%s]",requestJson,redirectUrlFieldKey));

    }
}
