package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import org.apache.commons.lang3.RandomStringUtils;

import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * jsApi中用于web前端请求实体
 * https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_1_4.shtml
 * @author jayheo
 */
public class JsApiWebJsRequestBean {

    /**
     * 应用ID
     * 商户申请的公众号对应的appid，由微信支付生成，可在公众号后台查看
     */
    @SerializedName("appId")
    private String appid;


    /**
     * 秒时间戳
     * 当前的时间，其他详见时间戳规则。
     * 示例值：1414561699
     */
    @SerializedName("timeStamp")
    private String secondTimestamp;


    /**
     * 随机字符串，不长于32位。
     * 示例值：5K8264ILTKCH16CQ2502SI8ZNMTM67VS
     */
    private String nonceStr;


    /**
     * JSAPI下单接口返回的prepay_id参数值，提交格式如：prepay_id=***
     * 示例值：prepay_id=wx201410272009395522657a690389285100
     */
    @SerializedName("package")
    private String packageName;


    /**
     * 签名类型，默认为RSA，仅支持RSA。
     */
    @SerializedName("signType")
    private String signatureType;


    /**
     * 签名，使用字段appId、timeStamp、nonceStr、package计算得出的签名值
     * 示例值：oR9d8PuhnIc+YZ8cBHFCwfgpaK9gd7vaRvkYD7rthRAZ\/X+QBhcCYL21N7cHCTUxbQ+EAt6Uy+lwSN22f5YZvI45MLko8Pfso0jm46v5hqcVwrk6uddkGuT+Cdvu4WBqDzaDjnNa5UK3GfE1Wfl2gHxIIY5lLdUgWFts17D4WuolLLkiFZV+JSHMvH7eaLdT9N5GBovBwu5yYKUR7skR8Fu+LozcSqQixnlEZUfyE55feLOQTUYzLmR9pNtPbPsu6WVhbNHMS3Ss2+AehHvz+n64GDmXxbX++IOBvm2olHu3PsOUGRwhudhVf7UcGcunXt8cqNjKNqZLhLw4jq\/xDg==
     */
    @SerializedName("paySign")
    private String signatureResult;

    public static JsApiWebJsRequestBean fromPayOrderResponse(JsApiCreatePayOrderResponse response){
        JsApiWebJsRequestBean instance = new JsApiWebJsRequestBean();
        //JSAPI下单接口返回的prepay_id参数值，提交格式如：prepay_id=***
        //示例值：prepay_id=wx201410272009395522657a690389285100
        instance.packageName = String.format("prepay_id=%s",response.getPackageId());
        instance.appid = response.getRequest().getAppid();
        instance.secondTimestamp = String.valueOf(System.currentTimeMillis()/1000);
        instance.nonceStr = RandomStringUtils.randomAlphanumeric(20);
        //根据文档的说明  目前仅支持RSA。
        instance.signatureType = "RSA";
        return instance;
    }


     public JsApiWebJsRequestBean signatureThenFillResult(String content){
        String message = Stream.of(appid,secondTimestamp,nonceStr,packageName).collect(Collectors.joining("\n","","\n"));
        this.signatureResult = WxpayMarketCertificateContainer.signatureThenBase64Message(message, content);
        return this;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getSecondTimestamp() {
        return secondTimestamp;
    }

    public void setSecondTimestamp(String secondTimestamp) {
        this.secondTimestamp = secondTimestamp;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getPackageName() {
        return packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getSignatureType() {
        return signatureType;
    }

    public void setSignatureType(String signatureType) {
        this.signatureType = signatureType;
    }

    public String getSignatureResult() {
        return signatureResult;
    }

    public void setSignatureResult(String signatureResult) {
        this.signatureResult = signatureResult;
    }

}
