package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.util.string.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * 交易订单的历史 包
 * @author jayheo
 */
public class TradeOrderHistoryPackage {


    /**
     * 原始内容
     */
    private String originContent;


    /**
     * 订单详情
     */
    List<TradeOrderHistoryRecordItem> orders;


    /**
     * 支付记录的数量
     */
    private Integer payOrderItemPiece;


    /**
     * 支付的总金额。
     */
    private Integer payOrderMoneySum;


    /**
     * 退款的总金额。
     */
    private Integer refundOrderMoneySum;


    public static Integer moneyFenFromYuan(String yuan){
        return StringUtil.yuan2fen(yuan).orElseThrow(()->new ServerException("输入的钱数据错误:[%s]",yuan));
    }

    public static List<String> splitItemFromOriginLine(String originLine){
        //`2021-09-18 18:28:11,`wx4c460d04aeb7982c,`1555371381,`0,`,`4200001212202109187293656122,`CWS2021091866487028628,`otPbOvoB7rvfz3Cokphv_VBXOR24,`MWEB,`SUCCESS,`OTHERS,`CNY,`0.01,`0.00,`产品订单-17640310,`,`0.00000,`0.54%,`0.01,`
        //`8,`0.08,`0.00,`0.00,`0.00000,`0.08,`0.00
        return Stream.of(originLine.split(","))
                .map(item -> item.contains("`") ? StringUtils.substringAfter(item, "`"): item)
                .collect(Collectors.toList());
    }


    public static TradeOrderHistoryPackage fromOriginContent(String originContent){
        TradeOrderHistoryPackage instance = new TradeOrderHistoryPackage();
        List<String> originLines = Stream.of(originContent.split("\n"))
                .map(line -> line.contains("\r") ? StringUtils.substringBefore(line, "\r"): line)
                .collect(Collectors.toList());
        instance.orders = originLines.stream().skip(1)
                .filter(TradeOrderHistoryRecordItem::isItemOriginLine)
                .map(TradeOrderHistoryRecordItem::fromOriginLine)
                .collect(Collectors.toList());
        Optional<String> lastOptional = originLines.stream().reduce((pre, next) -> next);

        String lastRecord = lastOptional.orElseThrow(() -> new ServerException("TODO 需要补充说明"));
        instance.fillSizeSumFromThis(lastRecord);
        return instance;
    }


    public static TradeOrderHistoryPackage createEmpty() {
        TradeOrderHistoryPackage instance = new TradeOrderHistoryPackage();
        instance.orders = new ArrayList<>();
        instance.payOrderItemPiece = 0;
        instance.payOrderMoneySum = 0;
        instance.refundOrderMoneySum = 0;
        return instance;
    }

    /**
     * 总交易单数,应结订单总金额,退款总金额,充值券退款总金额,手续费总金额,订单总金额,申请退款总金额
     * `8,`0.08,`0.00,`0.00,`0.00000,`0.08,`0.00
     * @param sizeSumLine
     * @return
     */
    public TradeOrderHistoryPackage fillSizeSumFromThis(String sizeSumLine){
        List<String> lastItems = splitItemFromOriginLine(sizeSumLine);
        this.payOrderItemPiece = Integer.parseInt(lastItems.get(0));
        this.payOrderMoneySum = moneyFenFromYuan(lastItems.get(5));
        this.refundOrderMoneySum = moneyFenFromYuan(lastItems.get(6));
        return this;
    }

    public String getOriginContent() {
        return originContent;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public List<TradeOrderHistoryRecordItem> getOrders() {
        return orders;
    }

    public void setOrders(List<TradeOrderHistoryRecordItem> orders) {
        this.orders = orders;
    }

    public Integer getPayOrderItemPiece() {
        return payOrderItemPiece;
    }

    public void setPayOrderItemPiece(Integer payOrderItemPiece) {
        this.payOrderItemPiece = payOrderItemPiece;
    }

    public Integer getPayOrderMoneySum() {
        return payOrderMoneySum;
    }

    public void setPayOrderMoneySum(Integer payOrderMoneySum) {
        this.payOrderMoneySum = payOrderMoneySum;
    }

    public Integer getRefundOrderMoneySum() {
        return refundOrderMoneySum;
    }

    public void setRefundOrderMoneySum(Integer refundOrderMoneySum) {
        this.refundOrderMoneySum = refundOrderMoneySum;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
