/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.mapp;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.mini.framework.third.weixin.mapp.WeixinMappSdk;
import com.mini.framework.third.weixin.mapp.model.AccessTokenResponse;
import com.mini.framework.third.weixin.mapp.model.MappCodePhotoRequest;
import com.mini.framework.third.weixin.mapp.model.MappCodePhotoResponse;
import com.mini.framework.third.weixin.mapp.model.SimpleAuthResponse;
import com.mini.framework.third.weixin.mapp.model.SimpleResponse;
import com.mini.framework.third.weixin.mapp.model.bean.SubscribeMessageParam;
import com.mini.framework.third.weixin.mapp.model.template.MessageTemplateCreateResponse;
import com.mini.framework.third.weixin.mapp.model.template.MessageTemplateLibraryResponse;
import com.mini.framework.third.weixin.mapp.model.template.MessageTemplateResponse;
import com.mini.framework.third.weixin.mapp.model.template.SiteMessageTemplatesResponse;
import com.mini.framework.third.weixin.server.util.tpmsg.WeixinJsonReqBuilder;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.SimpleHttpUtil;
import com.mini.framework.util.string.StringUtil;
import com.mini.framework.util.string.gson.builder.GsonData;
import java.util.Arrays;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class WeixinMappSdkSimpleImpl
implements WeixinMappSdk {
    private Logger logger = LogManager.getLogger(WeixinMappSdkSimpleImpl.class);
    @Value(value="${weixin.open.api.url:https://api.weixin.qq.com}")
    private String server;

    @Override
    public SimpleAuthResponse queryAuthByCode(String appid, String secret, String code) {
        AssertUtil.assertMethodRequire((Object)appid, (String)"appid");
        AssertUtil.assertMethodRequire((Object)secret, (String)"secret");
        AssertUtil.assertMethodRequire((Object)code, (String)"code");
        String action = "/sns/jscode2session?appid=%s&secret=%s&js_code=%s&grant_type=authorization_code";
        String url = this.server + String.format(action, appid, secret, code);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        SimpleAuthResponse resp = (SimpleAuthResponse)new Gson().fromJson(respStr, SimpleAuthResponse.class);
        resp.handle("code:%s", code);
        return resp;
    }

    @Override
    public byte[] createMappQrcode(String accessToken, MappCodePhotoRequest req) {
        AssertUtil.assertMethodRequire((Object)accessToken, (String)"accessToken");
        String action = "/wxa/getwxacodeunlimit?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String body = req.toJson();
        byte[] bytes = SimpleHttpUtil.simpleBytePost((String)url, (String)body);
        try {
            MappCodePhotoResponse resp = (MappCodePhotoResponse)new Gson().fromJson(StringUtil.toUtf8String((byte[])bytes), MappCodePhotoResponse.class);
            resp.handle("reqBody:%s", body);
        }
        catch (JsonSyntaxException e) {
            this.logger.debug(e.getMessage() + " \u51fa\u73b0\u8fd9\u4e2a\u5f02\u5e38\u662f\u6b63\u5e38\u7684\u60c5\u51b5\u5ffd\u7565\u5373\u53ef");
        }
        return bytes;
    }

    @Override
    public AccessTokenResponse createAccessToken(String appid, String secret) {
        AssertUtil.assertMethodRequire((Object)secret, (String)"secret");
        AssertUtil.assertMethodRequire((Object)appid, (String)"appid");
        String action = "/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";
        String url = this.server + String.format(action, appid, secret);
        String respStr = SimpleHttpUtil.simpleGet((String)url);
        AccessTokenResponse resp = (AccessTokenResponse)new Gson().fromJson(respStr, AccessTokenResponse.class);
        resp.handle("url:%s", url);
        return resp;
    }

    @Override
    public MessageTemplateLibraryResponse listWeixinMessageTemplates(String accessToken, int offset, int limit) {
        AssertUtil.assertMethodRequire((Object)accessToken, (String)"accessToken");
        int maxLimit = 20;
        String action = "/cgi-bin/wxopen/template/library/list?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        MessageTemplateLibraryResponse respSum = null;
        boolean haveMore = true;
        do {
            String reqBody = String.format("{\"offset\":%s,\"count\":%s}", offset, Math.min(limit, maxLimit));
            String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
            MessageTemplateLibraryResponse resp = (MessageTemplateLibraryResponse)new Gson().fromJson(respStr, MessageTemplateLibraryResponse.class);
            resp.handle("reqBody:%s", reqBody);
            boolean bl = haveMore = resp.getTemplates().size() > 0;
            if (respSum != null) {
                respSum.addTemplates(resp.getTemplates());
                respSum.setCount(resp.getCount());
            } else {
                respSum = resp;
            }
            offset += maxLimit;
        } while ((limit -= maxLimit) > 0 && haveMore);
        return respSum;
    }

    @Override
    public void deleteSiteMessageTemplate(String accessToken, String siteTemplateKey) {
    }

    @Override
    public MessageTemplateResponse getWeixinMessageTemplate(String accessToken, String templateKey) {
        AssertUtil.assertMethodRequire((Object)accessToken, (String)"accessToken");
        String action = "/cgi-bin/wxopen/template/library/get?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String reqBody = String.format("{\"id\":\"%s\"}", templateKey);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        MessageTemplateResponse resp = (MessageTemplateResponse)new Gson().fromJson(respStr, MessageTemplateResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public String createSiteMessageTemplate(String accessToken, String weixinTemplateKey, int[] keywordKeys) {
        AssertUtil.assertMethodRequire((Object)accessToken, (String)"accessToken");
        String action = "/cgi-bin/wxopen/template/add?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String reqBody = String.format("{\"id\":\"%s\",\"keyword_id_list\":%s}", weixinTemplateKey, Arrays.toString(keywordKeys));
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        MessageTemplateCreateResponse resp = (MessageTemplateCreateResponse)new Gson().fromJson(respStr, MessageTemplateCreateResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp.getTemplateId();
    }

    @Override
    public SiteMessageTemplatesResponse getSiteTemplates(String accessToken) {
        return null;
    }

    @Override
    public SiteMessageTemplatesResponse sendTemplateMessage(String accessToken, String openid, String siteTemplateId, String sendToken, String mappNamespace, String[] params, String[] importantKeywordKeys) {
        WeixinJsonReqBuilder msgBuilder = WeixinJsonReqBuilder.create().openid(openid).tempId(siteTemplateId).mappPathIfAbsent(mappNamespace).mappToken(sendToken).keyword(params);
        String reqBody = msgBuilder.build();
        AssertUtil.assertMethodRequire((Object)accessToken, (String)"accessToken");
        String action = "/cgi-bin/message/wxopen/template/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SiteMessageTemplatesResponse resp = (SiteMessageTemplatesResponse)new Gson().fromJson(respStr, SiteMessageTemplatesResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public SimpleResponse sendCustomMessageText(String accessToken, String openid, String text) {
        String reqBody = GsonData.build().param("touser", openid).param("msgtype", "text").object("text", textData -> textData.param("content", text)).toJson();
        String action = "/cgi-bin/message/custom/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public SimpleResponse sendCustomMessagePhoto(String accessToken, String openid, String photoUrl) {
        String reqBody = GsonData.build().param("touser", openid).param("msgtype", "image").object("image", textData -> textData.param("media_id", photoUrl)).toJson();
        String action = "/cgi-bin/message/custom/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public SimpleResponse sendSubscribeMessage(String accessToken, String openid, String templateId, List<SubscribeMessageParam> params) {
        GsonData requestData = GsonData.build().param("touser", openid).param("template_id", templateId);
        SubscribeMessageParam.fillBody(requestData, params);
        String requestBody = requestData.toJson();
        String action = "/cgi-bin/message/subscribe/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String responseBody = SimpleHttpUtil.simplePost((String)url, (String)requestBody);
        SimpleResponse response = (SimpleResponse)new Gson().fromJson(responseBody, SimpleResponse.class);
        response.handle("reqBody:%s", requestBody);
        return response;
    }

    @Override
    public SimpleResponse sendCustomMessagePhotoText(String accessToken, String openid, String title, String desc, String linkUrl, String icoUrl) {
        String reqBody = GsonData.build().param("touser", openid).param("msgtype", "link").object("link", textData -> textData.param("title", title).param("description", desc).param("url", linkUrl).param("thumbUrl", icoUrl)).toJson();
        String action = "/cgi-bin/message/custom/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }

    @Override
    public SimpleResponse sendCustomMessageMapp(String accessToken, String openid, String title, String namespace, String photoUrl) {
        String reqBody = GsonData.build().param("touser", openid).param("msgtype", "miniprogrampage").object("miniprogrampage", textData -> textData.param("title", title).param("pagepath", namespace).param("thumbMediaId", photoUrl)).toJson();
        String action = "/cgi-bin/message/custom/send?access_token=%s";
        String url = this.server + String.format(action, accessToken);
        String respStr = SimpleHttpUtil.simplePost((String)url, (String)reqBody);
        SimpleResponse resp = (SimpleResponse)new Gson().fromJson(respStr, SimpleResponse.class);
        resp.handle("reqBody:%s", reqBody);
        return resp;
    }
}

