/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.oauth2;

import com.mini.framework.third.weixin.server.client.WeixinServerAccountSdk;
import com.mini.framework.third.weixin.server.client.WeixinServerSdkSimpleImpl;
import com.mini.framework.third.weixin.server.model.WeixinServerAccountAccess;
import com.mini.framework.third.weixin.server.model.WeixinServerUserDetail;
import com.mini.framework.third.weixin.server.provider.WeixinServerAccessProvider;

public class Oauth2Client {
    private WeixinServerAccountSdk sdk;

    private static WeixinServerAccountSdk createServerSdkImpl(String secret, String appid) {
        WeixinServerSdkSimpleImpl sdk = new WeixinServerSdkSimpleImpl();
        WeixinServerAccountAccess access = new WeixinServerAccountAccess(secret, appid, null);
        sdk.setWeixinServerAccessProvider(WeixinServerAccessProvider.createInstance(access));
        sdk.setServer("https://api.weixin.qq.com");
        sdk.setSiteTokenProvider(appidType -> secret);
        return sdk;
    }

    public static Oauth2Client createClientByServerAccount(String appid, String secret) {
        Oauth2Client client = new Oauth2Client();
        client.sdk = Oauth2Client.createServerSdkImpl(secret, appid);
        return client;
    }

    public WeixinServerUserDetail queryAuthByCode(String code) {
        return this.sdk.queryAuthByCode(code);
    }
}

