/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay.client;

import com.mini.framework.core.exception.HandleIOException;
import com.mini.framework.core.exception.ThirdException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.pay.client.MappPrePayRequest;
import com.mini.framework.third.weixin.pay.client.MappPrePayResponse;
import com.mini.framework.third.weixin.pay.client.MappRefundResponse;
import com.mini.framework.third.weixin.pay.client.MappSiteTransferInfoResponse;
import com.mini.framework.third.weixin.pay.client.MappTransferResponse;
import com.mini.framework.third.weixin.pay.client.PayApi;
import com.mini.framework.third.weixin.pay.client.PublicPrePayRequest;
import com.mini.framework.third.weixin.pay.client.PublicPrePayResponse;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyRequest;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyResponse;
import com.mini.framework.third.weixin.pay.client.QueryOrderRequest;
import com.mini.framework.third.weixin.pay.client.QueryOrderResponse;
import com.mini.framework.third.weixin.pay.client.SiteQueryTransferInfoPreRequest;
import com.mini.framework.third.weixin.pay.client.StatusAbleResponse;
import com.mini.framework.third.weixin.pay.client.UserMappRefundPreRequest;
import com.mini.framework.third.weixin.pay.client.UserMappTransferPreRequest;
import com.mini.framework.third.weixin.pay.model.SitePayStatusType;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.MiniLogLevel;
import com.mini.framework.util.string.XStreamUtil;
import java.io.IOException;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.simplexml.SimpleXmlConverterFactory;

public class PayApiClient {
    private static Logger logger = LogManager.getLogger(PayApiClient.class);
    private static final String wxpayServerUrl = "https://api.mch.weixin.qq.com/";
    public static Retrofit wxpayServer = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com/").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.createNonStrict()).client(new OkHttpClient.Builder().addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build()).build();

    public static Retrofit wxpayCertServer(SSLContext sslContext) {
        return new Retrofit.Builder().baseUrl(wxpayServerUrl).addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.createNonStrict()).client(new OkHttpClient.Builder().sslSocketFactory(sslContext.getSocketFactory()).addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build()).build();
    }

    public static PublicPrePayResponse publicPay(PublicPrePayRequest request) {
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u62a5\u6587xml:{}", (Object)xmlReq);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<PublicPrePayResponse> call = ((PayApi)wxpayServer.create(PayApi.class)).publicPay(body);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            PublicPrePayResponse response = (PublicPrePayResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    public static PublicRefundApplyResponse publicRefundApply(SSLContext sslContext, PublicRefundApplyRequest request) {
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u9000\u6b3e\u62a5\u6587xml:{}", (Object)xmlReq);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<PublicRefundApplyResponse> call = ((PayApi)PayApiClient.wxpayCertServer(sslContext).create(PayApi.class)).refoundApply(body);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            PublicRefundApplyResponse response = (PublicRefundApplyResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    public static MappPrePayResponse mappPay(MappPrePayRequest request) {
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u62a5\u6587xml:{}", (Object)xmlReq);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<MappPrePayResponse> call = ((PayApi)wxpayServer.create(PayApi.class)).mappPay(body);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            MappPrePayResponse response = (MappPrePayResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    public static QueryOrderResponse queryOrder(QueryOrderRequest request) {
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u7684{}\u62a5\u6587xml:{}", (Object)request.messageType(), (Object)xmlReq);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<QueryOrderResponse> call = ((PayApi)wxpayServer.create(PayApi.class)).orderQuery(body);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            QueryOrderResponse response = (QueryOrderResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    public static MappSiteTransferInfoResponse mappTransferInfo(SiteQueryTransferInfoPreRequest request, SSLContext cert) {
        Retrofit payServer = PayApiClient.getWxPayServer(cert);
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u7684{}\u62a5\u6587xml:{}", (Object)request.messageType(), (Object)xmlReq);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<MappSiteTransferInfoResponse> call = ((PayApi)payServer.create(PayApi.class)).transferInfoQuery(body);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            MappSiteTransferInfoResponse response = (MappSiteTransferInfoResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    public static MappTransferResponse wechatPayTransfer(UserMappTransferPreRequest request, SSLContext cert) {
        Retrofit payServer = PayApiClient.getWxPayServer(cert);
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u7684{}\u62a5\u6587xml:{}", (Object)request.messageType(), (Object)xmlReq);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<MappTransferResponse> call = ((PayApi)payServer.create(PayApi.class)).transfers(requestBody);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u652f\u4ed8\u5931\u8d25", (Object[])new Object[0]);
            MappTransferResponse response = (MappTransferResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    private static Retrofit getWxPayServer(SSLContext sslContext) {
        return new Retrofit.Builder().baseUrl(wxpayServerUrl).addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.createNonStrict()).client(new OkHttpClient.Builder().hostnameVerifier((s, sslSession) -> true).retryOnConnectionFailure(true).sslSocketFactory(sslContext.getSocketFactory()).addInterceptor((Interceptor)new HttpLoggingInterceptor().setLevel(HttpLoggingInterceptor.Level.BODY)).build()).build();
    }

    public static MappRefundResponse mappRefund(UserMappRefundPreRequest request) {
        String xmlReq = XStreamUtil.toXml((Object)request);
        logger.log(MiniLogLevel.getKeyBizLog(), "\u51c6\u5907\u53d1\u5230\u817e\u8baf\u652f\u4ed8\u7684{}\u62a5\u6587xml:{}", (Object)request.messageType(), (Object)xmlReq);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xmlReq);
        Call<MappRefundResponse> call = ((PayApi)wxpayServer.create(PayApi.class)).refund(requestBody);
        try {
            Response retrofitResponse = call.execute();
            AssertUtil.simpleAssertByStatus((boolean)retrofitResponse.isSuccessful(), (StatusCode)Status.Third.weixin, (String)"\u9000\u6b3e\u5931\u8d25", (Object[])new Object[0]);
            MappRefundResponse response = (MappRefundResponse)retrofitResponse.body();
            PayApiClient.checkStatus(response);
            return response;
        }
        catch (IOException e) {
            throw new HandleIOException((Throwable)e, "\u5fae\u4fe1\u652f\u4ed8\u7f51\u7edc\u5f02\u5e38", new Object[0]);
        }
    }

    private static void checkStatus(StatusAbleResponse response) {
        String bizType = response.bizType();
        if (!"SUCCESS".equals(response.connCode())) {
            if ("\u8ba2\u5355\u5df2\u5168\u989d\u9000\u6b3e".equals(response.connDesc())) {
                throw new ThirdException(Status.Third.refundFullOfOrder, "%s\u8ba2\u5355\u5df2\u5168\u90e8\u9000\u6b3e\u4e86code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
            }
            if ("refund_fee\u5927\u4e8e\u53ef\u9000\u91d1\u989d".equals(response.connDesc())) {
                throw new ThirdException(Status.Third.refundOverOrderLimit, "%s\u9000\u6b3e\u8ba2\u5355\u5927\u4e8e\u53ef\u9000\u7684\u94b1code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
            }
            if ("\u4f60\u7684\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002".equals(response.connDesc())) {
                throw new ThirdException(Status.Third.refundIllegalOperateQpsLimit, "%s\u9000\u6b3e\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
            }
            if ("\u540c\u4e00\u7b14\u8ba2\u5355\u7684\u9000\u6b3e\u6570\u91cf\u8d85\u8fc7\u9650\u5236".equals(response.connDesc())) {
                throw new ThirdException(Status.Third.refundIllegalOperateTimeLimit, "%s\u9000\u6b3e\u64cd\u4f5c\u8d85\u8fc7\u6700\u5927\u6b21\u6570code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
            }
            if ("appid\u548cmch_id\u4e0d\u5339\u914d".equals(response.connDesc())) {
                throw new ThirdException(Status.Third.configAppidUnFoundError, "%s\u5546\u6237\u53f7\u4e2d\u6ca1\u6709\u5bf9\u5e94\u7684\u5fae\u4fe1appid,code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
            }
            throw new ThirdException(Status.Third.wxConn, "%s\u901a\u8baf\u5931\u8d25code:%s,msg:%s", new Object[]{bizType, response.connCode(), response.connDesc()});
        }
        if (!response.success()) {
            SitePayStatusType payStatus = SitePayStatusType.weixinPublicStatus(response.bizCode());
            if (payStatus != null) {
                throw new ThirdException(payStatus.getMap(), "%s\u4e1a\u52a1\u9519\u8befcode:%s,msg:%s", new Object[]{bizType, response.bizCode(), response.bizDesc()});
            }
            throw new ThirdException(Status.Third.weixin, "%s\u4e1a\u52a1\u9519\u8befcode:%s,msg:%s", new Object[]{bizType, response.bizCode(), response.bizDesc()});
        }
    }
}

