/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay.type;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.util.asserts.AssertUtil;
import java.util.stream.Stream;

public enum WeixinPayType {
    WXPAY_H5("wxpay_h5", "\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7\u652f\u4ed8", "JSAPI"),
    WXPAY_MWEB("MWEB", "\u5fae\u4fe1\u516c\u4f17\u8d26\u53f7\u652f\u4ed8", "MWEB");

    private String tradeType;
    private String code;
    private String name;

    private WeixinPayType(String code, String name, String tradeType) {
        this.code = code;
        this.name = name;
        this.tradeType = tradeType;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getTradeType() {
        return this.tradeType;
    }

    public static WeixinPayType getByCode(String code) {
        WeixinPayType type = Stream.of(WeixinPayType.values()).filter(oneType -> oneType.code.equals(code)).findAny().orElse(null);
        AssertUtil.assertNoBadReq((type != null ? 1 : 0) != 0, (StatusCode)Status.BadReq.illParam, (String)"\u627e\u4e0d\u5230:[%s]\u5bf9\u5e94\u7684\u652f\u4ed8\u7c7b\u578b", (Object[])new Object[]{code});
        return type;
    }
}

