/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model.template;

import com.mini.framework.core.exception.standard.CustomException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TemplateContentItem {
    private Boolean variable;
    private String varName;
    private String value;
    private String color;

    public TemplateContentItem() {
    }

    public static TemplateContentItem createStaticItem(String value) {
        return new TemplateContentItem(false, null, value, null);
    }

    public static TemplateContentItem createVariableItem(String varName, String value) {
        return TemplateContentItem.createVariableItem(varName, value, "#000000");
    }

    public static TemplateContentItem createVariableItem(String varName, String value, String color) {
        return new TemplateContentItem(true, varName, value, color);
    }

    public TemplateContentItem(Boolean variable, String varName, String value, String color) {
        this.variable = variable;
        this.varName = varName;
        this.value = value;
        this.color = color;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Boolean getVariable() {
        return this.variable;
    }

    public void setVariable(Boolean variable) {
        this.variable = variable;
    }

    public String getVarName() {
        return this.varName;
    }

    public void setVarName(String varName) {
        this.varName = varName;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public TemplateContentItem copy() {
        return new TemplateContentItem(this.variable, this.varName, this.value, this.color);
    }

    public String toValue(Map<String, Object> params) {
        if (this.variable.booleanValue()) {
            return String.valueOf(params.get(this.varName));
        }
        return this.value;
    }

    public boolean ifVariable() {
        return Optional.ofNullable(this.variable).orElse(false);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public <E extends CustomException> void validateSameDocumentVersion(TemplateContentItem otherItem, Function<String, E> exceptionSupplier) {
        if (this.ifVariable() != otherItem.ifVariable()) {
            throw (CustomException)exceptionSupplier.apply("\u4e0d\u80fd\u4e00\u4e2a\u662f\u53d8\u91cf\u4e00\u4e2a\u4e0d\u662f\u53d8\u91cf");
        }
        if (this.ifVariable()) {
            if (!Objects.equals(this.varName, otherItem.varName)) {
                throw (CustomException)exceptionSupplier.apply(String.format("\u53d8\u91cf\u540d\u5fc5\u987b\u4e00\u81f4:[%s]!=[%s]", this.varName, otherItem.varName));
            }
        } else if (!Objects.equals(this.value, otherItem.value)) {
            throw (CustomException)exceptionSupplier.apply(String.format("\u975e\u53d8\u91cf\u7684\u5185\u5bb9\u5fc5\u987b\u4e00\u81f4:[%s]!=[%s]", this.value, otherItem.value));
        }
    }
}

