/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.util;

import com.mini.framework.core.exception.HandleEnDeCodeException;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.log.Event5WBuilder;
import com.mini.framework.util.string.StringUtil;
import com.sun.org.apache.xerces.internal.impl.dv.util.Base64;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class WeixinAesCryptUtil {
    private static Logger logger = LogManager.getLogger(WeixinAesCryptUtil.class);
    private static boolean addProvider = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void sureAddProvider() {
        if (addProvider) return;
        Class<WeixinAesCryptUtil> clazz = WeixinAesCryptUtil.class;
        synchronized (WeixinAesCryptUtil.class) {
            if (addProvider) return;
            Security.addProvider((Provider)new BouncyCastleProvider());
            addProvider = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static String decryptData(String encryptedData, String iv, String sessionKey) {
        try {
            String result = WeixinAesCryptUtil.decryptDataThrows(encryptedData, iv, sessionKey);
            Event5WBuilder event = Event5WBuilder.event((int)1, (Object)"decryptData").what("\u89e3\u5bc6\u5fae\u4fe1\u6570\u636eencryptedData:%s,iv:%s,sessionKey:%s", new Object[]{encryptedData, iv, sessionKey}).result("result:%s", new Object[]{result});
            logger.debug((Object)event);
            return result;
        }
        catch (BadPaddingException e) {
            throw new HandleEnDeCodeException((Throwable)e, "\u89e3\u5bc6\u7801\u5fae\u4fe1\u5bc6\u6587\u65f6\u51fa\u9519,\u5982\u679c encryptedData \u6bd4sessionkey\u5bf9\u5e94\u7684code\u5148\u83b7\u53d6\u5c31\u4f1a\u7206\u51fa\u8fd9\u4e2a\u9519", new Object[0]);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException | InvalidParameterSpecException | IllegalBlockSizeException | NoSuchPaddingException e) {
            Event5WBuilder event = Event5WBuilder.event((int)2, (Object)"decryptDataError").what("\u89e3\u5bc6\u5fae\u4fe1\u6570\u636e\u7684\u65f6\u5019\u51fa\u9519encryptedData:%s,iv:%s,sessionKey:%s", new Object[]{encryptedData, iv, sessionKey}).why("\u5f02\u5e38:%s", new Object[]{e.getMessage()}).how("\u5177\u4f53\u770b\u9519\u8bef\u6808", new Object[0]);
            logger.error((Object)event);
            throw new HandleEnDeCodeException((Throwable)e, "\u89e3\u5bc6\u7801\u5fae\u4fe1\u5bc6\u6587\u65f6\u51fa\u9519", new Object[0]);
        }
        catch (Throwable e) {
            throw new HandleEnDeCodeException(e, "\u89e3\u5bc6\u7801\u5fae\u4fe1\u5bc6\u6587\u65f6\u51fa\u9519\u672a\u77e5\u5f02\u5e38", new Object[0]);
        }
    }

    private static String decryptDataThrows(String encryptedData, String iv, String sessionKey) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidParameterSpecException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchProviderException {
        AssertUtil.assertMethodRequire((Object)encryptedData, (String)"encryptedData");
        AssertUtil.assertMethodRequire((Object)sessionKey, (String)"sessionKey");
        AssertUtil.assertMethodRequire((Object)iv, (String)"iv");
        byte[] dataByte = Base64.decode(encryptedData);
        AssertUtil.validateParams((dataByte != null ? 1 : 0) != 0, (String)"encryptedData base64\u683c\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        byte[] keyByte = Base64.decode(sessionKey);
        AssertUtil.validateParams((keyByte != null ? 1 : 0) != 0, (String)"sessionKey base64\u683c\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        byte[] ivByte = Base64.decode(iv);
        AssertUtil.validateParams((ivByte != null ? 1 : 0) != 0, (String)"iv base64\u683c\u5f0f\u4e0d\u6b63\u786e", (Object[])new Object[0]);
        keyByte = WeixinAesCryptUtil.fillByte(keyByte, 16);
        WeixinAesCryptUtil.sureAddProvider();
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        SecretKeySpec spec = new SecretKeySpec(keyByte, "AES");
        AlgorithmParameters parameters = AlgorithmParameters.getInstance("AES");
        parameters.init(new IvParameterSpec(ivByte));
        cipher.init(2, (Key)spec, parameters);
        byte[] resultByte = cipher.doFinal(dataByte);
        String result = StringUtil.toUtf8String((byte[])resultByte);
        return result;
    }

    private static byte[] fillByte(byte[] sourseByte, int length) {
        AssertUtil.assertMethodRequire((Object)sourseByte, (String)"sourseByte");
        if (sourseByte.length % length != 0) {
            int groups = sourseByte.length / length + (sourseByte.length % length != 0 ? 1 : 0);
            byte[] result = new byte[groups * length];
            Arrays.fill(result, (byte)0);
            System.arraycopy(sourseByte, 0, result, 0, sourseByte.length);
            return result;
        }
        return sourseByte;
    }
}

