package com.mini.framework.third.express.model;

import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

import com.mini.framework.util.string.GsonUtil;

/**
 * 统一的快递传输信息
 * @author jayheo
 *
 */
public class ExpressTransportStatus {
	
	private String number;
	
	private String operateMarketCode;
	
	/**
	 * 原始的内容
	 */
	private String originalBody;

	private List<ExpressTransportStatusItem> items;
	
	/**
	 * 当前的时间
	 */
	private Date currDate;
	
	/**
	 * 当前的状态
	 */
	private ExpressTransportStage currStatus;

	public List<ExpressTransportStatusItem> getItems() {
		return items;
	}

	public void setItems(List<ExpressTransportStatusItem> items) {
		this.items = items;
	}
	
	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}

	public String getOperateMarketCode() {
		return operateMarketCode;
	}

	public void setOperateMarketCode(String operateMarketCode) {
		this.operateMarketCode = operateMarketCode;
	}
	
	public String getOriginalBody() {
		return originalBody;
	}

	public void setOriginalBody(String originalBody) {
		this.originalBody = originalBody;
	}

	public Date getCurrDate() {
		return currDate;
	}

	public void setCurrDate(Date currDate) {
		this.currDate = currDate;
	}

	public ExpressTransportStage getCurrStatus() {
		return currStatus;
	}

	public void setCurrStatus(ExpressTransportStage currStatus) {
		this.currStatus = currStatus;
	}

	public static ExpressTransportStatus fromJson(String json){
		return GsonUtil.buildMilliSecondDateGson().fromJson(json, ExpressTransportStatus.class);
	}
	public String toJson(){
		return GsonUtil.buildMilliSecondDateGson().toJson(this);
	}
	
	/**
	 * 返回最后一条记录的时间
	 * @return
	 */
	public Optional<Date> lastItemDate(){
		if(items!=null){
			return items.stream().map(ExpressTransportStatusItem::getDate).filter(Objects::nonNull).max(Comparator.comparing(Date::getTime));
		}else{
			return Optional.empty(); 
		}
	}

}
