package com.mini.framework.third.lizhi.model;

import java.util.Date;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.util.asserts.AssertUtil;

/**
 * <pre>
 * 优惠码:95589997,2.0,不限期,专栏优惠券,飞帅,已使用,2018-09-29 21:57:17.907047,https://m.lizhiweike.com/channel/321918?discount_code=95589997&y=1
 * 优惠码:95587370,2.0,不限期,专栏优惠券,未领取,可用,,https://m.lizhiweike.com/channel/321918?discount_code=95587370&y=1
 * </pre>
 */
public class TicketDto {

	/**
	 * 版本号
	 */
	private int version;

	/**
	 * 价格
	 */
	private Double price;

	/**
	 * 编号
	 */
	private String number;

	/**
	 * 访问url
	 */
	private String accessUrl;
	
	/**
	 * 券对应的目标url
	 */
	private String targetUrl;

	/**
	 * 使用者的名字
	 */
	private String useName;

	/**
	 * 使用的时间
	 */
	private Date userDate;

	private String line;
	
	/**
	 * 专栏
	 * https://m.lizhiweike.com/channel/321918?discount_code=95587370&y=1
	 * 其中 321918就是专栏
	 */
	private String channel;
	
	/**
	 * 优惠券包id
	 * 95587370，95589997 就是包id
	 * 
	 */
	private String packageKey;
	

	public int getVersion() {
		return version;
	}

	public void setVersion(int version) {
		this.version = version;
	}

	public Double getPrice() {
		return price;
	}

	public void setPrice(Double price) {
		this.price = price;
	}

	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}

	public String getAccessUrl() {
		return accessUrl;
	}

	public void setAccessUrl(String accessUrl) {
		this.accessUrl = accessUrl;
	}

	public String getUseName() {
		return useName;
	}

	public void setUseName(String useName) {
		this.useName = useName;
	}

	public Date getUserDate() {
		return userDate;
	}

	public void setUserDate(Date userDate) {
		this.userDate = userDate;
	}

	public String getLine() {
		return line;
	}

	public void setLine(String line) {
		this.line = line;
	}
	
	public String getChannel() {
		return channel;
	}

	public void setChannel(String channel) {
		this.channel = channel;
	}
	
	public String getPackageKey() {
		return packageKey;
	}

	public void setPackageKey(String packageKey) {
		this.packageKey = packageKey;
	}
	
	public String getTargetUrl() {
		return targetUrl;
	}

	public void setTargetUrl(String targetUrl) {
		this.targetUrl = targetUrl;
	}

	/**
	 * 能不能匹配
	 * @return
	 */
	public boolean isValid(){
		return price!=null && number!=null && accessUrl!=null && channel!=null; 
	}
	
	/**
	 * 已使用
	 * @return
	 */
	public boolean isUsed(){
		return  isValid() && (useName != null&&!"未领取".equals(useName));
	}
	
	public boolean isNotUsed(){
		return !isUsed();
	}
	
	/**
	 * 得到int型的价格
	 * 这里注意一定是使用过 isValid 方法的才能使用这个方法。
	 * @return
	 */
	public  int getIntPrice(){
		AssertUtil.assertSupport(price!=null,"对于没有price的数据不允许使用这个方法");
		return (int) Math.round(price *100);
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}

}
