package com.mini.framework.third.weixin.notice.server.model.resp;

import com.thoughtworks.xstream.annotations.XStreamAlias;


/*
https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140453
<xml><ToUserName>< ![CDATA[toUser] ]></ToUserName><FromUserName>< ![CDATA[fromUser] ]></FromUserName><CreateTime>1351776360</CreateTime><MsgType>< ![CDATA[link] ]></MsgType><Title>< ![CDATA[公众平台官网链接] ]></Title><Description>< ![CDATA[公众平台官网链接] ]></Description><Url>< ![CDATA[url] ]></Url><MsgId>1234567890123456</MsgId></xml>

参数	描述
ToUserName	接收方微信号
FromUserName	发送方微信号，若为普通用户，则是一个OpenID
CreateTime	消息创建时间
MsgType	消息类型，link
Title	消息标题
Description	消息描述
Url	消息链接
MsgId	消息id，64位整型

*/
/**
 * 链接消息的通知
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class LinkNotice extends WeixinNotice{
	@XStreamAlias("Description")
	private String desc;
	
	@XStreamAlias("Url")
	private String url;
	
	@XStreamAlias("Title")
	private String title;

	
	public String getDesc() {
		return desc;
	}

	public void setDesc(String desc) {
		this.desc = desc;
	}

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getTitle() {
		return title;
	}

	public void setTitle(String title) {
		this.title = title;
	}

	
}
