package com.mini.framework.third.weixin.pay.client;

import org.simpleframework.xml.Element;

import com.mini.framework.core.exception.standard.UnsupportedException;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 
 * 通用通讯响应报文
 * @author jayheo
 *
 */
public abstract class ConnMessageResponse extends ConnMessage implements StatusAbleResponse{
	@XStreamAlias("return_code")
    @Element(name = "return_code")
    private String returnCode;

	@XStreamAlias("return_msg")
    @Element(name = "return_msg", required = false)
    private String returnMsg;

    @Element(name = "result_code", required = false)
    @XStreamAlias("result_code")
    private String resultCode;

    @Element(name = "err_code", required = false)
    @XStreamAlias("err_code")
    private String errCode;

    @Element(name = "err_code_des", required = false)
    @XStreamAlias("err_code_des")
    private String errCodeDes;

	public String getReturnCode() {
		return returnCode;
	}

	public void setReturnCode(String returnCode) {
		this.returnCode = returnCode;
	}

	public String getReturnMsg() {
		return returnMsg;
	}

	public void setReturnMsg(String returnMsg) {
		this.returnMsg = returnMsg;
	}

	public String getResultCode() {
		return resultCode;
	}

	public void setResultCode(String resultCode) {
		this.resultCode = resultCode;
	}

	public String getErrCode() {
		return errCode;
	}

	public void setErrCode(String errCode) {
		this.errCode = errCode;
	}

	public String getErrCodeDes() {
		return errCodeDes;
	}

	public void setErrCodeDes(String errCodeDes) {
		this.errCodeDes = errCodeDes;
	}

	@Override
	public void setSign(String sign) {
		throw new UnsupportedException("不支持对响应报文进行加签");
	}

	@Override
	public StatusAbleResponseBean showStatus() {
		StatusAbleResponseBean status = new StatusAbleResponseBean(returnCode, returnMsg, resultCode, errCode, errCodeDes);
		status.setBizType("公众号支付");
		return status;
	}
    
}
