package com.mini.framework.third.weixin.pay.client;

import org.simpleframework.xml.Element;

import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("xml")
public class QueryOrderResponse extends ConnMessageResponse {

    /**
     * 交易状态
     */
    @Element(name = "trade_state", required = false)
    @XStreamAlias("trade_state")
	private String tradeState; 
    
    @Element(name = "out_trade_no", required = false)
    @XStreamAlias("out_trade_no")
    private String sitePayOrder;
    
    
    /**
     * 微信侧的订单id
     */
    @Element(name = "transaction_id", required = false)
    @XStreamAlias("transaction_id")
    private String weixinOrderNo;
    
    /**
     * 交易状态描述
     */
    @Element(name = "trade_state_desc", required = false)
    @XStreamAlias("trade_state_desc")
    private String tradeStateDesc;
    
    
	@Override
	public String messageType() {

		return "微信支付查询订单响应";
	}

	public String getTradeState() {
		return tradeState;
	}

	public void setTradeState(String tradeState) {
		this.tradeState = tradeState;
	}

	public String getSitePayOrder() {
		return sitePayOrder;
	}

	public void setSitePayOrder(String sitePayOrder) {
		this.sitePayOrder = sitePayOrder;
	}

	public String getTradeStateDesc() {
		return tradeStateDesc;
	}

	public void setTradeStateDesc(String tradeStateDesc) {
		this.tradeStateDesc = tradeStateDesc;
	}

	public String getWeixinOrderNo() {
		return weixinOrderNo;
	}

	public void setWeixinOrderNo(String weixinOrderNo) {
		this.weixinOrderNo = weixinOrderNo;
	}
	
}
