package com.mini.framework.third.weixin.util;

import java.util.function.Function;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.http.HttpResStatusUtil;
import com.mini.framework.util.string.RegexUtil;


//https://mp.weixin.qq.com/wiki?t=resource/res_main&id=mp1421140839

/**
 * 头像资源工具类
 * 用户处理一下头像相关的东西
 * 微信的用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像）<br>
 * ，用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
 * @author jayheo
 *
 */
public class HeadResourseUtil {

	private static Logger logger = LogManager.getLogger(HeadResourseUtil.class);
	
	public static String findWeixinPhotoResourse(String weixinRes){
		String[] weixinPhotoRegexs = new String[]{
				"^http.*wx.qlogo.cn.*/132$",
				"^http.*thirdwx.qlogo.cn.*/132$",
		};
		
		for (String regex : weixinPhotoRegexs) {
			String match = RegexUtil.getMatch(regex, weixinRes);
			if(match!=null){
				return match.substring(0, weixinRes.length()-3) + "0";
			}
		}
		return null;
	}
	
	/**
	 * 尝试修改微信的资源，
	 * 比如原来是微信的资源，现在改成自己的资源，如果不是的就直接忽略，
	 * 不允许传空值过来
	 * @param weixinRes
	 * @param resChanger
	 * @return
	 */
	public static String tryChangeWeixinPhoto(String weixinRes,Function<String, String> resChanger){
		AssertUtil.assertMethodRequire(weixinRes, "weixinRes");
		String res = findWeixinPhotoResourse(weixinRes);
		if(res!=null && HttpResStatusUtil.isExist(res)){
			try{
				return resChanger.apply(res);
			}catch(Throwable e){
				//这个方法定义的是尝试取，那么就不能出现报错的情况。所以要catch异常
				logger.debug("尝试换取资源时出错,res:[{}]",res ,e);
			}
		}
		return weixinRes;
	}
	
}
