package com.mini.framework.third.weixin.wxpay.v3.client;

import com.mini.framework.third.weixin.wxpay.util.FeignUtil;
import com.mini.framework.third.weixin.wxpay.util.certificate.HandlerAfterCertificateSignature;
import com.mini.framework.third.weixin.wxpay.util.certificate.CertificateSignatureRequireParams;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.util.test.TestFileSupport;
import feign.RequestInterceptor;
import feign.RequestTemplate;

/**
 * 请求头的拦截器
 * @author jayheo
 */
public class SignatureRequestInterceptor implements RequestInterceptor, TestFileSupport {

    /**
     * 证书。
     */
    public final WxpayMarketCertificateContainer certificate;

    public SignatureRequestInterceptor(WxpayMarketCertificateContainer certificate) {
        this.certificate = certificate;
    }

    @Override
    public void apply(RequestTemplate template) {

        //微信说，如果没有话，应该用长度 为0的字符串代替。
        String bodyString = FeignUtil.findRequestBody(template).orElse("");
        
        CertificateSignatureRequireParams params = new CertificateSignatureRequireParams();
        params.setApiMethod(template.request().method());
        params.setRequestBody(bodyString);
        params.setApiUrlPath(template.request().url());

        certificate.signatureThenFillBack(params, new HandlerAfterCertificateSignature() {
            @Override
            public void foundHeaderAuthToken(String authToken) {
                template.header("Authorization",authToken);
            }

            @Override
            public void foundSignature(String signature) {
                //template.header("Authorization",signature);
            }
        });

    }
    
    
    
    
    
}
