package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.client.ClientConfigAttach;
import com.mini.framework.third.weixin.wxpay.v3.client.ParamBeanValidate;
import com.mini.framework.util.asserts.AssertUtil;

/**
 * https://pay.weixin.qq.com/wiki/doc/apiv3/apis/chapter3_3_9.shtml
 * @author jayheo
 */
public class WxpayRefundPayOrderRequest implements ClientConfigAttach, ParamBeanValidate {


    /**
     * 商户付款的订单号<BR>
     * string[6,32]<BR>
     * 必填：是<br>
     * 商户系统内部订单号，只能是数字、大小写字母_-*且在同一个商户号下唯一<BR>
     * 例如:1217752501201407033233368018<BR>
     */
    @SerializedName("out_trade_no")
    private String sitePayOrderNumber;


    /**
     * 微信支付订单号<BR>
     * 微信支付系统生成的订单号。<BR>
     * 例如:1217752501201407033233368018
     */
    @SerializedName("transaction_id")
    private String wxpayPayOrderNumber;


    /**
     * 商户退款单号<BR>
     * string[6,32]<BR>
     * 必填：是<br>
     * 商户系统内部的退款单号，商户系统内部唯一，只能是数字、大小写字母_-|*@ ，同一退款单号多次请求只退一笔。<BR>
     * 例如:1217752501201407033233368018<BR>
     */
    @SerializedName("out_refund_no")
    private String siteRefundOrderNumber;

    @SerializedName("reason")
    private String refundReason;



    //退款结果回调url  不是必须的不传了。

    /**
     * 订单金额<BR>
     * 必填：是<br>
     * 订单金额信息<BR>
     */
    @SerializedName("amount")
    private RefundMoney refundAmount;

    @Override
    public void applyClientConfig(WxpayMarketCertificateContainer certificateContainer) {
        //什么都不用做
    }

    @Override
    public void beforeRequestValidate() {
        //TODO 检查一下一些必要检查的。
    }


    /**
     * 填充人民币，单位是分钱。
     * @param refundAmount
     * @param payAmount
     * @return
     */
    public WxpayRefundPayOrderRequest fillChinaAmount(int refundAmount,int payAmount){
        AssertUtil.assertNotFatalBug(refundAmount>0,"退款金额必须大于0");
        AssertUtil.assertNotFatalBug(refundAmount<=payAmount,"退款金额:[%s]不能大于支付金额:[%s]",refundAmount,payAmount);
        this.refundAmount = RefundMoney.createChinaAmount(refundAmount, payAmount);
        return this;

    }


    public static class RefundMoney{
        /**
         * 退款金额
         * 退款金额，单位为分，只能为整数，不能超过原订单支付金额。
         */
        @SerializedName("refund")
        private Integer refundAmount;

        /**
         * 总金额<BR>
         * 必填：是<br>
         * 订单总金额，单位为分。<BR>
         * 例如:100<BR>
         */
        @SerializedName("total")
        private Integer payAmount;


        /**
         * 货币类型<BR>
         * string[1,16]<BR>
         * 必填：是<br>
         * 	CNY：人民币，境内商户号仅支持人民币。<BR>
         * 例如:CNY<BR>
         */
        @SerializedName("currency")
        private String currency;


        /**
         * 创建人民币的退款金额
         * @param refundAmount
         * @param payAmount
         * @return
         */
        public static RefundMoney createChinaAmount(int refundAmount,int payAmount){
            RefundMoney instance = new RefundMoney();
            instance.refundAmount = refundAmount;
            instance.payAmount = payAmount;
            instance.currency = "CNY";
            return instance;
        }
    }


    public String getSitePayOrderNumber() {
        return sitePayOrderNumber;
    }

    public void setSitePayOrderNumber(String sitePayOrderNumber) {
        this.sitePayOrderNumber = sitePayOrderNumber;
    }

    public String getWxpayPayOrderNumber() {
        return wxpayPayOrderNumber;
    }

    public void setWxpayPayOrderNumber(String wxpayPayOrderNumber) {
        this.wxpayPayOrderNumber = wxpayPayOrderNumber;
    }

    public String getSiteRefundOrderNumber() {
        return siteRefundOrderNumber;
    }

    public void setSiteRefundOrderNumber(String siteRefundOrderNumber) {
        this.siteRefundOrderNumber = siteRefundOrderNumber;
    }

    public String getRefundReason() {
        return refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public RefundMoney getRefundAmount() {
        return refundAmount;
    }

    public void setRefundAmount(RefundMoney refundAmount) {
        this.refundAmount = refundAmount;
    }
}
