/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console;

import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.third.weixin.console.model.WeixinCurlCommand;
import com.mini.framework.util.http.linked.HttpClientHelper;
import com.mini.framework.util.http.linked.HttpMethod;
import com.mini.framework.util.http.linked.HttpRequest;
import com.mini.framework.util.http.linked.HttpResponse;
import com.mini.framework.util.string.RegexUtil;

public class ConsoleProxyCommandHelper {
    public static WeixinCurlCommand parseBachCurl(String command) {
        String[] items = command.split(" \\-H ");
        String url = null;
        String cookie = null;
        for (String item : items) {
            String urlTemp;
            String cookieTemp = RegexUtil.getMatch((String)"'cookie:(.*)'", (String)item, (int)1);
            if (cookieTemp != null) {
                cookie = cookieTemp;
            }
            if ((urlTemp = RegexUtil.getMatch((String)".*curl.*'(.*)'", (String)item, (int)1)) == null) continue;
            url = urlTemp;
        }
        if (cookie != null && url != null) {
            return new WeixinCurlCommand(url, cookie);
        }
        throw new BadReqException("\u547d\u4ee4\u4e2d\u89e3\u6790\u4e0d\u51faurl[%s]\u548ccookie:[%s],command:[%s]", new Object[]{url, cookie, command});
    }

    public static String exeBachCurl(String command) {
        WeixinCurlCommand request = ConsoleProxyCommandHelper.parseBachCurl(command);
        return ConsoleProxyCommandHelper.exeUseUrlAndCookie(request.getUrl(), request.getCookie());
    }

    public static String exeUseUrlAndCookie(String url, String cookie) {
        HttpRequest request = HttpRequest.create().url(url).header("cookie", cookie).method(HttpMethod.get);
        HttpResponse response = HttpClientHelper.execute((HttpRequest)request);
        return response.getBodyString();
    }
}

