/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay;

import com.mini.framework.core.exception.HandleException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLContext;
import org.apache.http.ssl.SSLContexts;

public class PayCertUtil {
    public static SSLContext loadCertFactoryQuiet(InputStream certInputStream, String certSecret) {
        try {
            return PayCertUtil.loadCertFactory(certInputStream, certSecret);
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new HandleException((Throwable)e, "\u8bfb\u53d6\u8bc1\u4e66\u7684\u65f6\u5019\u51fa\u9519", new Object[0]);
        }
    }

    public static SSLContext loadCertFactory(InputStream certInputStream, String certSecret) throws KeyStoreException, KeyManagementException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore keyStore = KeyStore.getInstance("PKCS12");
        char[] certSecretChars = certSecret.toCharArray();
        keyStore.load(certInputStream, certSecretChars);
        SSLContext sslcontext = SSLContexts.custom().loadKeyMaterial(keyStore, certSecretChars).build();
        return sslcontext;
    }
}

