/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.pay;

import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.pay.PayCertUtil;
import com.mini.framework.third.weixin.pay.client.MappJsPayResponse;
import com.mini.framework.third.weixin.pay.client.MappPrePayRequest;
import com.mini.framework.third.weixin.pay.client.MappPrePayResponse;
import com.mini.framework.third.weixin.pay.client.PayApiClient;
import com.mini.framework.third.weixin.pay.client.PublicJsPayResponse;
import com.mini.framework.third.weixin.pay.client.PublicPrePayRequest;
import com.mini.framework.third.weixin.pay.client.PublicPrePayResponse;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyRequest;
import com.mini.framework.third.weixin.pay.client.PublicRefundApplyResponse;
import com.mini.framework.third.weixin.pay.client.QueryOrderRequest;
import com.mini.framework.third.weixin.pay.client.QueryOrderResponse;
import com.mini.framework.third.weixin.pay.model.UserMappPayRequest;
import com.mini.framework.third.weixin.pay.model.UserMappPayResponse;
import com.mini.framework.third.weixin.pay.model.UserPublicPayRequest;
import com.mini.framework.third.weixin.pay.model.UserPublicPayResponse;
import com.mini.framework.third.weixin.pay.model.UserPublicRefundApplyRequest;
import com.mini.framework.third.weixin.pay.model.UserPublicRefundApplyResponse;
import com.mini.framework.third.weixin.pay.model.WxMappPayConfig;
import com.mini.framework.third.weixin.pay.model.WxPublicPayConfig;
import com.mini.framework.util.asserts.AssertUtil;
import com.mini.framework.util.paas.MultiSiteConfig;
import com.mini.framework.util.string.XStreamUtil;
import java.io.ByteArrayInputStream;
import javax.net.ssl.SSLContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WinxinPayHelper<S> {
    Logger logger = LogManager.getLogger(WinxinPayHelper.class);
    private MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig;
    private MultiSiteConfig<S, WxMappPayConfig> siteMappPayConfig;

    public WinxinPayHelper(MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig) {
        this.siteH5PayConfig = siteH5PayConfig;
    }

    public WinxinPayHelper(MultiSiteConfig<S, WxPublicPayConfig> siteH5PayConfig, MultiSiteConfig<S, WxMappPayConfig> siteMappPayConfig) {
        this.siteH5PayConfig = siteH5PayConfig;
        this.siteMappPayConfig = siteMappPayConfig;
    }

    @Deprecated
    public UserPublicPayResponse publicPrePay(UserPublicPayRequest request) {
        AssertUtil.assertNotFatalProgramConfig((this.siteH5PayConfig != null ? 1 : 0) != 0, (StatusCode)Status.Server.programConfigJava, (String)"\u6ca1\u6709\u914d\u7f6e\u670d\u52a1\u53f7\u652f\u4ed8\u7684\u5546\u5bb6\u914d\u7f6e", (Object[])new Object[0]);
        WxPublicPayConfig config = (WxPublicPayConfig)this.siteH5PayConfig.currBean();
        return WinxinPayHelper.publicPrePay(request, config);
    }

    public static UserPublicPayResponse publicPrePay(UserPublicPayRequest request, WxPublicPayConfig config) {
        AssertUtil.assertMethodRequire((Object)request, (String)"request");
        AssertUtil.assertMethodRequire((Object)config, (String)"config");
        PublicPrePayRequest connRequest = new PublicPrePayRequest(request);
        connRequest.fillConfig(config);
        connRequest.setNotifyUrl(config.getNotifyUrl());
        connRequest.sign(config.getMchKey());
        PublicPrePayResponse connresponse = PayApiClient.publicPay(connRequest);
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String packAge = "prepay_id=" + connresponse.getPrepayId();
        UserPublicPayResponse response = new UserPublicPayResponse();
        response.setAppId(connresponse.getAppid());
        response.setTimeStamp(timeStamp);
        response.setPackAge(packAge);
        response.sign(config.getMchKey());
        response.setOutTradeNo(request.getOrderId());
        response.setMwebUrl(connresponse.getMwebUrl());
        return response;
    }

    public static UserPublicRefundApplyResponse publicApplyRefund(UserPublicRefundApplyRequest request, WxPublicPayConfig config) {
        AssertUtil.assertMethodRequire((Object)request, (String)"request");
        AssertUtil.assertMethodRequire((Object)config, (String)"config");
        PublicRefundApplyRequest connRequest = new PublicRefundApplyRequest();
        connRequest.fillConfig(config);
        connRequest.setTotalFee(request.getTotalMoney());
        connRequest.setRefundFee(request.getRefundMoney());
        connRequest.setOutTradeNo(request.getSitePayOrderNo());
        connRequest.setOutRefundNo(request.getSiteRefundNo());
        connRequest.sign(config.getMchKey());
        AssertUtil.assertNoBadReq((config.getCertSecret() != null ? 1 : 0) != 0, (StatusCode)Status.BadReq.noReq, (String)"\u8bc1\u4e66\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        AssertUtil.assertNoBadReq((config.getMchCert() != null ? 1 : 0) != 0, (StatusCode)Status.BadReq.noReq, (String)"\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        SSLContext sslContext = PayCertUtil.loadCertFactoryQuiet(new ByteArrayInputStream(config.getMchCert()), config.getCertSecret());
        PublicRefundApplyResponse connResponse = PayApiClient.publicRefundApply(sslContext, connRequest);
        UserPublicRefundApplyResponse response = new UserPublicRefundApplyResponse();
        response.setAppId(connResponse.getAppid());
        response.setWeixinRefundOrderNo(connResponse.getWeixinRefundNo());
        return response;
    }

    @Deprecated
    public UserMappPayResponse mappPrePay(UserMappPayRequest request) {
        WxMappPayConfig config = (WxMappPayConfig)this.siteMappPayConfig.currBean();
        return WinxinPayHelper.mappPrePay(request, config);
    }

    public static UserMappPayResponse mappPrePay(UserMappPayRequest request, WxMappPayConfig config) {
        MappPrePayRequest connRequest = new MappPrePayRequest(request);
        connRequest.fillConfig(config);
        connRequest.setNotifyUrl(config.getNotifyUrl());
        connRequest.sign(config.getMchKey());
        MappPrePayResponse connresponse = PayApiClient.mappPay(connRequest);
        String timeStamp = String.valueOf(System.currentTimeMillis() / 1000L);
        String packAge = "prepay_id=" + connresponse.getPrepayId();
        UserMappPayResponse response = new UserMappPayResponse();
        response.setAppId(connresponse.getAppid());
        response.setTimeStamp(timeStamp);
        response.setPackAge(packAge);
        response.sign(config.getMchKey());
        response.setOutTradeNo(request.getOrderId());
        response.setMwebUrl(connresponse.getMwebUrl());
        return response;
    }

    public String mappPayStatus(String sitePayOrder) {
        WxMappPayConfig config = (WxMappPayConfig)this.siteMappPayConfig.currBean();
        QueryOrderRequest connRequest = new QueryOrderRequest();
        connRequest.fillConfig(config);
        connRequest.setSitePayOrder(sitePayOrder);
        connRequest.sign(config.getMchKey());
        QueryOrderResponse connResponse = PayApiClient.queryOrder(connRequest);
        return connResponse.getTradeState();
    }

    public String publicPayStatus(String sitePayOrder) {
        WxPublicPayConfig config = (WxPublicPayConfig)this.siteH5PayConfig.currBean();
        return WinxinPayHelper.serverPayStatus(sitePayOrder, config);
    }

    public static String serverPayStatus(String sitePayOrder, WxPublicPayConfig config) {
        return WinxinPayHelper.publicJsapiPayStatus(sitePayOrder, config).getTradeState();
    }

    public static QueryOrderResponse publicJsapiPayStatus(String sitePayOrder, WxPublicPayConfig config) {
        QueryOrderRequest connRequest = new QueryOrderRequest();
        connRequest.fillConfig(config);
        connRequest.setSitePayOrder(sitePayOrder);
        connRequest.sign(config.getMchKey());
        QueryOrderResponse connResponse = PayApiClient.queryOrder(connRequest);
        return connResponse;
    }

    public static PublicJsPayResponse publicJsPayNotice(String noticeResp) {
        PublicJsPayResponse resp = (PublicJsPayResponse)XStreamUtil.fromXml((String)noticeResp, PublicJsPayResponse.class);
        return resp;
    }

    public static MappJsPayResponse mappJsPayNotice(String noticeResp) {
        MappJsPayResponse resp = (MappJsPayResponse)XStreamUtil.fromXml((String)noticeResp, MappJsPayResponse.class);
        return resp;
    }

    public static String createNoticeAnswer(boolean success, String msg) {
        return String.format("<xml><return_code><![CDATA[%s]]></return_code><return_msg><![CDATA[%s]]></return_msg></xml>", success ? "SUCCESS" : "FAIL", msg);
    }
}

