/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model.menu;

import java.util.Optional;
import java.util.stream.Stream;

public enum WeixinServerButtonType {
    group(null),
    click("click"),
    linkMapp("miniprogram"),
    link("view"),
    readQrcode("scancode_push"),
    readQrcodeWait("scancode_waitmsg"),
    shot("pic_sysphoto"),
    album("pic_photo_or_album"),
    sendPhotos("pic_weixin"),
    location("location_select");

    private String weixinKey;

    private WeixinServerButtonType(String weixinKey) {
        this.weixinKey = weixinKey;
    }

    public boolean matchType(WeixinServerButtonType type) {
        return this.equals((Object)type);
    }

    public String weixinKey() {
        return this.weixinKey;
    }

    public boolean matchWeixinKey(String weixinKey) {
        if (this.weixinKey == null) {
            return weixinKey == null;
        }
        return this.weixinKey.equals(weixinKey);
    }

    public static Optional<WeixinServerButtonType> fromWeixinKey(String weixinKey) {
        return Stream.of(WeixinServerButtonType.values()).filter(type -> type.matchWeixinKey(weixinKey)).findFirst();
    }

    public static void showDoc1() {
    }

    public static void showDoc2() {
    }
}

