/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.util.tpmsg;

import com.google.gson.Gson;
import java.util.LinkedHashMap;
import java.util.Map;

public class WeixinJsonReqBuilder
extends LinkedHashMap<String, Object> {
    private static final long serialVersionUID = 851371762354258832L;
    private static final String openidKey = "touser";
    private static final String mappTokenKey = "form_id";
    private static final String mappPathKey = "page";
    private static final String tempIdKey = "template_id";
    private static final String clickUrlKey = "url";
    private static final String bodyKey = "data";
    private static final String paramValueKey = "value";
    private static final String paramColorKey = "color";
    private static final String defaultColor = "#173177";
    private LinkedHashMap<String, Map<String, String>> body;

    public static WeixinJsonReqBuilder create() {
        WeixinJsonReqBuilder msg = new WeixinJsonReqBuilder();
        return msg.init();
    }

    private WeixinJsonReqBuilder init() {
        this.body = new LinkedHashMap();
        return this.body(this.body);
    }

    private WeixinJsonReqBuilder map(String key, Object val) {
        this.put(key, val);
        return this;
    }

    public WeixinJsonReqBuilder openid(String openid) {
        return this.map(openidKey, openid);
    }

    public WeixinJsonReqBuilder mappToken(String token) {
        return this.map(mappTokenKey, token);
    }

    public WeixinJsonReqBuilder mappPathIfAbsent(String mappPath) {
        this.putIfAbsent(mappPathKey, mappPath);
        return this;
    }

    public WeixinJsonReqBuilder clickUrl(String clickUrl) {
        return this.map(clickUrlKey, clickUrl);
    }

    public WeixinJsonReqBuilder tempId(String tempId) {
        return this.map(tempIdKey, tempId);
    }

    private WeixinJsonReqBuilder body(Object body) {
        return this.map(bodyKey, body);
    }

    public WeixinJsonReqBuilder param(String name, String param, String color) {
        LinkedHashMap<String, String> entry = new LinkedHashMap<String, String>(2);
        entry.put(paramColorKey, color);
        entry.put(paramValueKey, param);
        this.body.put(name, entry);
        return this;
    }

    public WeixinJsonReqBuilder param(String name, String param) {
        return this.param(name, param, defaultColor);
    }

    public WeixinJsonReqBuilder keyword(String ... values) {
        for (int i = 0; i < values.length; ++i) {
            String value = values[i];
            this.param("keyword" + (i + 1), value, defaultColor);
        }
        return this;
    }

    private void sort() {
        Object bodyObj = this.remove(bodyKey);
        this.put(bodyKey, bodyObj);
    }

    public String build() {
        this.sort();
        return new Gson().toJson((Object)this);
    }
}

