/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.mini.framework.core.exception.ServerException;
import com.mini.framework.third.weixin.wxpay.v3.model.weixin.TradeOrderHistoryPackage;
import com.mini.framework.util.asserts.AssertUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class TradeOrderHistoryRecordItem {
    private String originContent;
    private Date orderDate;
    private String appid;
    private String marketKey;
    private String weixinOrderNumber;
    private String siteOrderNumber;
    private String openid;
    private String tradeChannelType;
    private String weixinStatus;
    private Integer orderMoney;
    private String description;

    public static TradeOrderHistoryRecordItem fromOriginLine(String originLine) {
        TradeOrderHistoryRecordItem instance = new TradeOrderHistoryRecordItem();
        instance.originContent = originLine;
        instance.fillFromThisOriginContent();
        return instance;
    }

    public static boolean isItemOriginLine(String originLine) {
        List<String> items = TradeOrderHistoryPackage.splitItemFromOriginLine(originLine);
        return items.size() >= 19 && items.size() <= 20;
    }

    public TradeOrderHistoryRecordItem fillFromThisOriginContent() {
        AssertUtil.assertNotFatalBug((this.originContent != null ? 1 : 0) != 0, (String)"originContent\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> items = TradeOrderHistoryPackage.splitItemFromOriginLine(this.originContent);
        TradeOrderHistoryRecordItem.isItemOriginLine(this.originContent);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-DD HH:mm:ss");
        try {
            this.orderDate = format.parse(items.get(0));
        }
        catch (ParseException e) {
            throw new ServerException((Throwable)e, "TODO \u65e5\u671f\u89e3\u6790\u9519\u8bef", new Object[0]);
        }
        this.appid = items.get(1);
        this.marketKey = items.get(2);
        this.weixinOrderNumber = items.get(5);
        this.siteOrderNumber = items.get(6);
        this.openid = items.get(7);
        this.tradeChannelType = items.get(8);
        this.weixinStatus = items.get(9);
        this.orderMoney = TradeOrderHistoryPackage.moneyFenFromYuan(items.get(12));
        this.description = items.get(14);
        return this;
    }

    public String getOriginContent() {
        return this.originContent;
    }

    public void setOriginContent(String originContent) {
        this.originContent = originContent;
    }

    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getAppid() {
        return this.appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMarketKey() {
        return this.marketKey;
    }

    public void setMarketKey(String marketKey) {
        this.marketKey = marketKey;
    }

    public String getWeixinOrderNumber() {
        return this.weixinOrderNumber;
    }

    public void setWeixinOrderNumber(String weixinOrderNumber) {
        this.weixinOrderNumber = weixinOrderNumber;
    }

    public String getSiteOrderNumber() {
        return this.siteOrderNumber;
    }

    public void setSiteOrderNumber(String siteOrderNumber) {
        this.siteOrderNumber = siteOrderNumber;
    }

    public String getOpenid() {
        return this.openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getTradeChannelType() {
        return this.tradeChannelType;
    }

    public void setTradeChannelType(String tradeChannelType) {
        this.tradeChannelType = tradeChannelType;
    }

    public String getWeixinStatus() {
        return this.weixinStatus;
    }

    public void setWeixinStatus(String weixinStatus) {
        this.weixinStatus = weixinStatus;
    }

    public Integer getOrderMoney() {
        return this.orderMoney;
    }

    public void setOrderMoney(Integer orderMoney) {
        this.orderMoney = orderMoney;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

