/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.wxpay.v3.model.weixin;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.wxpay.util.certificate.WxpayMarketCertificateContainer;
import com.mini.framework.third.weixin.wxpay.v3.client.ClientConfigAttach;
import com.mini.framework.third.weixin.wxpay.v3.client.ParamBeanValidate;
import com.mini.framework.util.asserts.AssertUtil;

public class WxpayRefundPayOrderRequest
implements ClientConfigAttach,
ParamBeanValidate {
    @SerializedName(value="out_trade_no")
    private String sitePayOrderNumber;
    @SerializedName(value="transaction_id")
    private String wxpayPayOrderNumber;
    @SerializedName(value="out_refund_no")
    private String siteRefundOrderNumber;
    @SerializedName(value="reason")
    private String refundReason;
    @SerializedName(value="amount")
    private RefundMoney refundAmount;

    @Override
    public void applyClientConfig(WxpayMarketCertificateContainer certificateContainer) {
    }

    @Override
    public void beforeRequestValidate() {
    }

    public WxpayRefundPayOrderRequest fillChinaAmount(int refundAmount, int payAmount) {
        AssertUtil.assertNotFatalBug((refundAmount > 0 ? 1 : 0) != 0, (String)"\u9000\u6b3e\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0", (Object[])new Object[0]);
        AssertUtil.assertNotFatalBug((refundAmount <= payAmount ? 1 : 0) != 0, (String)"\u9000\u6b3e\u91d1\u989d:[%s]\u4e0d\u80fd\u5927\u4e8e\u652f\u4ed8\u91d1\u989d:[%s]", (Object[])new Object[]{refundAmount, payAmount});
        this.refundAmount = RefundMoney.createChinaAmount(refundAmount, payAmount);
        return this;
    }

    public String getSitePayOrderNumber() {
        return this.sitePayOrderNumber;
    }

    public void setSitePayOrderNumber(String sitePayOrderNumber) {
        this.sitePayOrderNumber = sitePayOrderNumber;
    }

    public String getWxpayPayOrderNumber() {
        return this.wxpayPayOrderNumber;
    }

    public void setWxpayPayOrderNumber(String wxpayPayOrderNumber) {
        this.wxpayPayOrderNumber = wxpayPayOrderNumber;
    }

    public String getSiteRefundOrderNumber() {
        return this.siteRefundOrderNumber;
    }

    public void setSiteRefundOrderNumber(String siteRefundOrderNumber) {
        this.siteRefundOrderNumber = siteRefundOrderNumber;
    }

    public String getRefundReason() {
        return this.refundReason;
    }

    public void setRefundReason(String refundReason) {
        this.refundReason = refundReason;
    }

    public RefundMoney getRefundAmount() {
        return this.refundAmount;
    }

    public void setRefundAmount(RefundMoney refundAmount) {
        this.refundAmount = refundAmount;
    }

    public static class RefundMoney {
        @SerializedName(value="refund")
        private Integer refundAmount;
        @SerializedName(value="total")
        private Integer payAmount;
        @SerializedName(value="currency")
        private String currency;

        public static RefundMoney createChinaAmount(int refundAmount, int payAmount) {
            RefundMoney instance = new RefundMoney();
            instance.refundAmount = refundAmount;
            instance.payAmount = payAmount;
            instance.currency = "CNY";
            return instance;
        }
    }
}

