package com.mini.framework.third.weixin.mapp.model;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.google.gson.Gson;
import com.mini.framework.util.string.GsonUtil;

/**
 * http://wiki.xxggpt.com/docs/wykjdev/mapp-template-message
 * 小程序的form表单的id登记
 * @author jayheo
 *
 */
public class MappFormIdMarker {

	private String formId;
	private String appid;
	private String userId;
	private Date date;
	public String getFormId() {
		return formId;
	}
	public void setFormId(String formId) {
		this.formId = formId;
	}
	public String getAppid() {
		return appid;
	}
	public void setAppid(String appid) {
		this.appid = appid;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	
	public boolean ifUseful(){
		return formId!=null && appid!=null && date!=null && userId!=null;
	}
	
	public static List<MappFormIdMarker> fromListJson(String listJson){
	    Gson gson = GsonUtil.buildMilliSecondDateGson();
	    List<MappFormIdMarker> formIds = GsonUtil.fromListJson(MappFormIdMarker.class, listJson,gson);
		return formIds;
	}
	
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
	
}
