package com.mini.framework.third.weixin.notice.server.model.resp;

import org.apache.commons.lang3.builder.ToStringBuilder;

import com.mini.framework.third.weixin.notice.server.util.WeixinNoticeMsgFactory;
import com.thoughtworks.xstream.annotations.XStreamAlias;

/**
 * 答复微信的报文<br>
 * @author jayheo
 *
 */
@XStreamAlias("xml")
public class WeixinAskMsg {
	/**
	 * ToUserName	是	接收方帐号（收到的OpenID）
	 * */
	@XStreamAlias("ToUserName")
	private String eventOpenId;
	/**
	 * FromUserName	是	开发者微信号
	 * */
	@XStreamAlias("FromUserName")
	private String servAcc;
	/**
	 * CreateTime	是	消息创建时间 （整型）
	 * */
	@XStreamAlias("CreateTime")
	private long createDate;
	/**
	 * MsgType	是	text
	 * */
	@XStreamAlias("MsgType")
	private String type;
	/**
	 * Content	是	回复的消息内容（换行：在content中能够换行，微信客户端就支持换行显示）
	 * */
	@XStreamAlias("Content")
	private String content;
	
	
	public String getEventOpenId() {
		return eventOpenId;
	}
	public void setEventOpenId(String eventOpenId) {
		this.eventOpenId = eventOpenId;
	}
	public long getCreateDate() {
		return createDate;
	}
	public void setCreateDate(long createDate) {
		this.createDate = createDate;
	}
	public String getType() {
		return type;
	}
	public void setType(String type) {
		this.type = type;
	}
	public String getContent() {
		return content;
	}
	public void setContent(String content) {
		this.content = content;
	}
	
	public String getServAcc() {
		return servAcc;
	}
	public void setServAcc(String servAcc) {
		this.servAcc = servAcc;
	}
	public void setContent(String content,Object ...params) {
		this.setContent(String.format(content, params));
	}
	public void setNoneContent(){
		//微信文档说明回复长度为0的字符串或者success代表不回复任何内容
		this.setContent(null);
	}
	
	public boolean ifNoneContent(){
		// 暂时这里代表不回复任何消息
		return content==null || content.length()==0;
	}
	
	public String toAnswerWeixinResponse(){
		if(ifNoneContent()){
			//微信的文档有点坑，他说的回复succes是直接回复一个字符串，而不是一个xml中包含这个success
			return "success";
		}else{
			return WeixinNoticeMsgFactory.toXmlAsk(this);
		}
	}
	
	public WeixinAskMsg(WeixinNotice notice, String type){
		super();
		//通知和响应正好是把接受和发送方对换一下位置
		this.eventOpenId = notice.getEventOpenid();
		this.servAcc = notice.getServAcc();
		this.createDate = System.currentTimeMillis()/1000;
		this.type = type;
	}
	@Override
	public String toString() {
		return ToStringBuilder.reflectionToString(this);
	}
}
