package com.mini.framework.third.weixin.pay.client;


/**
 * 
 * 有状态的响应
 * 用余处理  微信支付通讯的错误
 * 
 * 
 * 
 * @author jayheo
 *
 */

/*
 * https://pay.weixin.qq.com/wiki/doc/api/jsapi_sl.php?chapter=9_1
返回状态码	return_code	是	String(16)	SUCCESS	SUCCESS/FAIL 此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
返回信息	return_msg	否	String(128)	签名失败	返回信息，如非空，为错误原因\签名失败\参数格式校验错误
业务结果	result_code	是	String(16)	SUCCESS	SUCCESS/FAIL
错误代码	err_code	否	String(32)	SYSTEMERROR	详细参见第6节错误列表
错误代码描述	err_code_des	否	String(128)	系统错误	错误返回的信息描述

*/
public interface StatusAbleResponse {
	/**
	 * 通讯状态码
	 * @return
	 */
	default String connCode(){
		return showStatus().getConnCode();
	}
	/**
	 * 通讯描述
	 * @return
	 */
	default String connDesc(){

		return showStatus().getConnDesc();
	}
	
	/**
	 * 是否成功
	 * @return
	 */
	default boolean success(){
		return "SUCCESS".equals(showStatus().getSuccess());
	}

	default String bizCode(){
		return showStatus().getBizCode();
	}
	
	default String bizDesc(){
		return showStatus().getBizDesc();
	}
	
	default String bizType(){
		return showStatus().getBizType();
	}
	
	StatusAbleResponseBean showStatus();
}
