package com.mini.framework.third.weixin.pay.client;

import com.mini.framework.third.weixin.pay.model.UserMappRefundRequest;
import com.thoughtworks.xstream.annotations.XStreamAlias;

@XStreamAlias("xml")
public class UserMappRefundPreRequest extends ConnMessageRequest implements MessageMd5Signable {

    @XStreamAlias("out_trade_no")
    private String outTradeNo;

    @XStreamAlias("total_fee")
    private int totalFee;

    @XStreamAlias("refund_fee")
    private int refundFee;

    @XStreamAlias("refund_desc")
    private String refundDesc;

    //TODO 发起退款需要这个通知的url吗？不需要吧。
    @XStreamAlias("notify_url")
    private String notifyUrl;

    public UserMappRefundPreRequest(UserMappRefundRequest request) {
            this.setOutTradeNo(request.getOrderId());
            this.setTotalFee(request.getOrderAmount());
            this.setRefundFee(request.getOrderAmount());
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public int getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(int totalFee) {
        this.totalFee = totalFee;
    }

    public int getRefundFee() {
        return refundFee;
    }

    public void setRefundFee(int refundFee) {
        this.refundFee = refundFee;
    }

    public String getRefundDesc() {
        return refundDesc;
    }

    public void setRefundDesc(String refundDesc) {
        this.refundDesc = refundDesc;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    @Override
    public String messageType() {
        return "订单退款请求";
    }
}
