package com.mini.framework.third.weixin.server.model;

import com.google.gson.annotations.SerializedName;
import com.mini.framework.third.weixin.server.comm.AbstractResponse;
import com.mini.framework.third.weixin.util.HeadResourseUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import java.io.Serializable;
import java.util.Optional;
import java.util.function.Function;

public class WeixinBaseUserDetail extends AbstractResponse implements Serializable{
	/**
	 * 
	 */
	private static final long serialVersionUID = 8921834510591181079L;

	private static final Logger logger = LogManager.getLogger(WeixinBaseUserDetail.class);

	@SerializedName("openid")
	private String openId;
	@SerializedName("nickname")
	private String nick;
	@SerializedName("sex")
	private Integer sex;
	@SerializedName("province")
	private String province;
	@SerializedName("city")
	private String city;
	@SerializedName("country")
	private String country;

	/**
	 * 用户头像，最后一个数值代表正方形头像大小（有0、46、64、96、132数值可选，0代表640*640正方形头像），用户没有头像时该项为空。若用户更换头像，原有头像URL将失效。
	 * 以下是个人微信号的头像的例子。
	 * https://thirdwx.qlogo.cn/mmopen/vi_32/Q0j4TwGTfTKyn23gKz7GxCLptSic6jwH3yBybVkiaFJ9icVNY3SjOEFeGTm8hlwCzEkWBjAicwBDkpak4dKBB9556A/132
	 */
	@SerializedName("headimgurl")
	private String headIco;
	@SerializedName("privilege")
	private String privileges[];
	@SerializedName("unionid")
	private String unionId;
	public String getOpenId() {
		return openId;
	}
	public void setOpenId(String openId) {
		this.openId = openId;
	}
	public String getNick() {
		return nick;
	}
	public void setNick(String nick) {
		this.nick = nick;
	}
	public Integer getSex() {
		return sex;
	}
	public void setSex(Integer sex) {
		this.sex = sex;
	}
	public String getProvince() {
		return province;
	}
	public void setProvince(String province) {
		this.province = province;
	}
	public String getCity() {
		return city;
	}
	public void setCity(String city) {
		this.city = city;
	}
	public String getCountry() {
		return country;
	}
	public void setCountry(String country) {
		this.country = country;
	}
	public String getHeadIco() {
		return headIco;
	}
	public void setHeadIco(String headIco) {
		this.headIco = headIco;
	}
	public String[] getPrivileges() {
		return privileges;
	}
	public void setPrivileges(String[] privileges) {
		this.privileges = privileges;
	}
	public String getUnionId() {
		return unionId;
	}
	public void setUnionId(String unionId) {
		this.unionId = unionId;
	}
	
	public boolean haveDetail(){
		return nick!=null;
	}
	
	/**
	 * 组装签名
	 * @return
	 */
	public String assemSign(){
		String type;
		if(sex==null){
			type = "网友";
		}else if(sex==1){
			type = "小哥哥";
		}else if(sex==2){
			type = "小姐姐";
		}else{
			type = "网友";
		}
		return String.format("我是来自%s，%s省，%s市的%s" , getCountry() ,getProvince() , getCity(),type);
	}


	/**
	 * 查询可用的头像的源地址
	 * @return
	 */
	public Optional<String> findUsefulOriginHeadIcon(){
		return Optional.ofNullable(headIco).map(HeadResourseUtil::findWeixinPhotoResourse);
	}
	/**
	 * 查询可用的头像的源地址
	 * @return
	 */
	public Optional<String> loadUsefulOriginHeadIcon(Function<String, String> resourceChanger){
		return findUsefulOriginHeadIcon().map(resource->{
			try{
				return resourceChanger.apply(resource);
			}catch (Throwable e){
				logger.error(String.format("尝试换取资源时出错,res:[%s]", resource) ,e);
				return null;
			}
		});
	}
	
}
