/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.console.model;

import com.mini.framework.third.weixin.console.model.WeixinCurlCommand;
import com.mini.framework.util.asserts.AssertUtil;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class WeixinCurlCommandSectionable
extends WeixinCurlCommand {
    private Integer offset;
    private Integer limit;
    private Integer length;

    public WeixinCurlCommandSectionable(String url, String cookie) {
        super(url, cookie);
    }

    public Integer getOffset() {
        return this.offset;
    }

    public void setOffset(Integer offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public WeixinCurlCommandSectionable setSection(int offset, int limit) {
        this.offset = offset;
        this.limit = limit;
        this.setUrlIntParam("begin", this.offset);
        this.setUrlIntParam("count", this.limit);
        return this;
    }

    public WeixinCurlCommandSectionable setSection(int offset, int limit, int length) {
        this.setSection(offset, limit);
        this.length = length;
        return this;
    }

    public WeixinCurlCommandSectionable() {
        super(null, null);
    }

    public WeixinCurlCommandSectionable(WeixinCurlCommand command) {
        this(command.getUrl(), command.getCookie());
    }

    public boolean nextSection(Integer count) {
        boolean haveNext;
        AssertUtil.assertMethodRequire((Object)count, (String)"count");
        boolean bl = haveNext = count > this.offset + this.limit;
        if (haveNext) {
            this.offset = this.offset + this.limit;
            this.limit = Math.min(count - this.offset, this.limit);
            this.setUrlIntParam("begin", this.offset);
            this.setUrlIntParam("count", this.limit);
        }
        return haveNext;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

