/*
 * Decompiled with CFR 0.152.
 */
package com.mini.framework.third.weixin.server.model.template;

import com.google.gson.Gson;
import com.mini.framework.core.exception.BadReqException;
import com.mini.framework.core.exception.standard.CustomException;
import com.mini.framework.core.status.Status;
import com.mini.framework.core.status.StatusCode;
import com.mini.framework.third.weixin.server.model.template.TemplateContentItem;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemplateDocumentContent {
    private List<TemplateContentItem> contentItems;
    private String keywordFillExample;

    public List<TemplateContentItem> getContentItems() {
        return this.contentItems;
    }

    public void setContentItems(List<TemplateContentItem> contentItems) {
        this.contentItems = contentItems;
    }

    public String getKeywordFillExample() {
        return this.keywordFillExample;
    }

    public void setKeywordFillExample(String keywordFillExample) {
        this.keywordFillExample = keywordFillExample;
    }

    public Stream<TemplateContentItem> showVariableItemsStream() {
        return this.showVariableItems().stream();
    }

    public List<TemplateContentItem> showVariableItems() {
        return this.showContentItemsStream().filter(TemplateContentItem::ifVariable).collect(Collectors.toList());
    }

    public Stream<TemplateContentItem> showContentItemsStream() {
        return this.showContentItems().stream();
    }

    public List<TemplateContentItem> showContentItems() {
        return Optional.ofNullable(this.contentItems).orElse(new ArrayList());
    }

    public static TemplateDocumentContent fromTextDocument(String text) {
        ArrayList<TemplateContentItem> items = new ArrayList<TemplateContentItem>();
        TemplateDocumentContent content = new TemplateDocumentContent();
        content.setContentItems(items);
        String variablePattern = "\\{\\{([a-zA-Z0-9]*)\\.DATA\\}\\}";
        Pattern pattern = Pattern.compile(variablePattern);
        String[] staticContents = pattern.split(text);
        Matcher matcher = pattern.matcher(text);
        ArrayList<String> matchs = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group(1);
            matchs.add(group);
        }
        for (int i = 0; i < matchs.size(); ++i) {
            items.add(TemplateContentItem.createStaticItem(staticContents[i]));
            items.add(TemplateContentItem.createVariableItem((String)matchs.get(i), ""));
        }
        if (matchs.size() + 1 == staticContents.length) {
            items.add(TemplateContentItem.createStaticItem(staticContents[matchs.size()]));
        }
        return content;
    }

    public String applyTemplateByParams(Map<String, Object> params) {
        return this.contentItems.stream().map(item -> item.toValue(params)).collect(Collectors.joining(""));
    }

    public String applyTemplateByParamAsValue() {
        return this.applyTemplateByParamFinder(Function.identity());
    }

    public String applyTemplateByParamFinder(Function<String, String> variableValue) {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        this.contentItems.stream().filter(TemplateContentItem::ifVariable).map(TemplateContentItem::getVarName).forEach(vn -> params.put((String)vn, variableValue.apply((String)vn)));
        return this.applyTemplateByParams(params);
    }

    public static TemplateDocumentContent fromJson(String json) {
        return (TemplateDocumentContent)new Gson().fromJson(json, TemplateDocumentContent.class);
    }

    public String applyTemplateByFixedParam(String variableValue) {
        return this.applyTemplateByParamFinder(vn -> variableValue);
    }

    public TemplateDocumentContent createKeywordFillExample(Function<String, String> variableValue) {
        this.keywordFillExample = this.applyTemplateByParamFinder(variableValue);
        return this;
    }

    public TemplateDocumentContent createKeywordFillExample() {
        return this.createKeywordFillExample(var -> String.format("#{{%s}}", var));
    }

    public Optional<String> matchSameDocumentVersionFindCause(TemplateDocumentContent other) {
        StatusCode status = Status.BadReq.illParam;
        try {
            this.validateSameDocumentVersion(other, msg -> new BadReqException(status, msg, new Object[0]));
            return Optional.empty();
        }
        catch (BadReqException e) {
            if (e.matchStatus(status)) {
                return Optional.of(e.getMessage());
            }
            throw e;
        }
    }

    public <E extends CustomException> void validateSameDocumentVersion(TemplateDocumentContent other, Function<String, E> exceptionSupplier) {
        if (this.contentItems == null && other.contentItems == null) {
            return;
        }
        if (this.contentItems == null || other.contentItems == null) {
            throw (CustomException)exceptionSupplier.apply("contentItems\u4e0d\u80fd\u4e00\u4e2a\u4e3a\u7a7a\u4e00\u4e2a\u4e0d\u4e3a\u7a7a");
        }
        if (this.contentItems.size() != other.contentItems.size()) {
            throw (CustomException)exceptionSupplier.apply(String.format("contentItems.size\u5fc5\u987b\u4e00\u6837:[%s]!=[%s]", this.contentItems.size(), other.contentItems.size()));
        }
        for (int index = 0; index < this.contentItems.size(); ++index) {
            TemplateContentItem thisItem = this.contentItems.get(index);
            TemplateContentItem otherItem = other.contentItems.get(index);
            int offset = index + 1;
            thisItem.validateSameDocumentVersion(otherItem, (String msg) -> (CustomException)exceptionSupplier.apply(String.format("\u7b2c[%s]\u8bb0\u5f55\u4e0d\u5339\u914d %s", offset, msg)));
        }
    }
}

